package com.tbyf.his.web.dataImport.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.vo.CreateFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.DataFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataField;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.entity.MetaField;
import com.tbyf.his.web.dataImport.mapper.DataFieldMapper;
import com.tbyf.his.web.dataImport.service.DataFieldService;
import com.tbyf.his.web.dataImport.service.DataTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class DataFieldServiceImpl extends ServiceImpl<DataFieldMapper, DataField> implements DataFieldService {

    @Autowired
    private DataFieldMapper dataFieldMapper;

    @Autowired
    private DataTemplateService dataTemplateService;

    @Override
    public Page<DataFieldVO> queryField(QueryFieldParam param) {
        final Page<DataFieldVO> page = Page.of(param.getPageNum(), param.getPageSize());
        // 查询需要对比的信息
        final DataTemplate template = dataTemplateService.getById(param.getTemplateId());
        if (template != null) {
            final DataTemplate dataTemplate = dataTemplateService.getOne(Wrappers.lambdaQuery(DataTemplate.class)
                    .eq(DataTemplate::getOrgName, template.getOrgName())
                    .lt(DataTemplate::getYear, template.getYear())
                    .orderByDesc(DataTemplate::getYear), false);
            if (dataTemplate != null) {
                param.setOldTemplateId(dataTemplate.getId());
            }
        }
        return (Page<DataFieldVO>) dataFieldMapper.queryField(page, param);
    }

    @Override
    public void fieldMatch(List<MetaField> list, DataField field, List<DataField> fieldMatchList) {
        if (StringUtils.isBlank(field.getTitle())) {
            return;
        }
        MetaField metaField = null;
        DataField dataField = null;
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> {
                if (StringUtils.isNotBlank(item.getFieldComment())) {
                    item.setRatio(DataImportUtils.getSimilarityRatio(field.getTitle(), item.getFieldComment()));
                } else {
                    item.setRatio(0);
                }
            });
            Optional<MetaField> max = list.stream().max(Comparator.comparing(MetaField::getRatio));
            if (max.isPresent()) {
                metaField = max.get();
            }
        }
        if (!CollectionUtils.isEmpty(fieldMatchList)) {
            fieldMatchList.forEach(item -> {
                if (StringUtils.isNotBlank(item.getTitle())) {
                    item.setRatio(DataImportUtils.getSimilarityRatio(field.getTitle(), item.getTitle()));
                } else {
                    item.setRatio(0);
                }
            });
            Optional<DataField> max = fieldMatchList.stream().max(Comparator.comparing(DataField::getRatio));
            if (max.isPresent()) {
                dataField = max.get();
            }
        }
        if (metaField == null) {
            if (dataField != null && dataField.getRatio() >= 0.5) {
                log.debug("title:[{}],匹配指标名称:[{}],达成字段:[{}],相似度:[{}]",
                        field.getTitle(), dataField.getTitle(), dataField.getField(), dataField.getRatio());
                field.setField(dataField.getField());
            }
        } else {
            if (dataField == null) {
                if (metaField.getRatio() >= 0.5) {
                    log.debug("title:[{}],匹配指标名称:[{}],达成字段:[{}],相似度:[{}]",
                            field.getTitle(), metaField.getFieldComment(), metaField.getFieldName(), metaField.getRatio());
                    field.setField(metaField.getId());
                }
            } else {
                if (dataField.getRatio() >= metaField.getRatio() && dataField.getRatio() >= 0.5) {
                    log.debug("title:[{}],匹配指标名称:[{}],达成字段:[{}],相似度:[{}]",
                            field.getTitle(), dataField.getTitle(), dataField.getField(), dataField.getRatio());
                    field.setField(dataField.getField());
                } else if (metaField.getRatio() >= 0.5) {
                    log.debug("title:[{}],匹配指标名称:[{}],达成字段:[{}],相似度:[{}]",
                            field.getTitle(), metaField.getFieldComment(), metaField.getFieldName(), metaField.getRatio());
                    field.setField(metaField.getId());
                }
            }
        }
    }

    @Override
    public List<DataField> listFieldMatchList(String templateId) {
        return dataFieldMapper.listFieldMatchList(templateId);
    }

    @Override
    public List<CreateFieldVO> getCreateFields(String templateId) {
        return dataFieldMapper.getCreateFields(templateId);
    }

    @Override
    public List<VerifyVO> getFieldsInfo(List<String> fieldList, String templateId) {
        return dataFieldMapper.getFieldsInfo(fieldList, templateId);
    }
}
