package com.tbyf.his.web.controller.apiconvert;

import com.tbyf.his.apiconvert.domain.FieldMap;
import com.tbyf.his.apiconvert.service.IFieldMappingService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/system/fieldmap")
public class FieldMapController extends BaseController {

    @Autowired
    private IFieldMappingService FieldService;

    @Log(title = "新增字段映射", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult addMap(@Validated @RequestBody FieldMap field) {
        return toAjax(FieldService.insertFieldMap(field));
    }

    /**
     * 删除字段映射
     */
    @Log(title = "删除字段映射", businessType = BusinessType.DELETE)
    @DeleteMapping("/{sourceFieldId}/{targetFieldId}/{apiBaseinfoId}")
    public AjaxResult removeMap(@PathVariable Long sourceFieldId,
                                @PathVariable Long targetFieldId,
                                @PathVariable Long apiBaseinfoId) {
        return toAjax(FieldService.deleteFieldMap(sourceFieldId, targetFieldId, apiBaseinfoId));
    }

    /**
     * 字段映射
     */
    @Log(title = "字段映射管理", businessType = BusinessType.DELETE)
    @GetMapping("/selectFieldMappingByApiId/{apiId}")
    public AjaxResult selectFieldMappingByApiId(@PathVariable Long apiId) {
        List<FieldMap> sourceAndTargets = FieldService.selectFieldMappingByApiId(apiId);
        return AjaxResult.success(sourceAndTargets);
    }
}
