package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "data_import_template", autoResultMap = true)
@ApiModel(value = "数据导入模板表", description = "数据导入模板表")
public class DataImportTemplate extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "模板ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "模板名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "机构类型")
    @TableField("org_name")
    private String orgName;

    @ApiModelProperty(value = "导入状态 1-已导入 0-未导入")
    @TableField("import_status")
    private String importStatus;

    @ApiModelProperty(value = "数据年份")
    @TableField("year")
    private String year;

    @JsonFormat(pattern = FORMAT, timezone = TIMEZONE)
    @ApiModelProperty(value = "上次导入时间")
    @TableField("import_time")
    private Date importTime;

    @ApiModelProperty(value = "数据源ID")
    @TableField("datasource_id")
    private String dataSourceId;

    @ApiModelProperty(value = "表名")
    @TableField("table_name")
    private String tableName;

    public String createComment() {
        return Stream.of(name, orgName, year)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.joining(" - "));
    }

}
