package com.tbyf.his.job.obj;

import com.tbyf.his.apiconvert.domain.ExecutSqlsInfo;
import com.tbyf.his.job.domain.SysJobNew;
import com.tbyf.his.system.service.ISysDatasourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: fr
 * @date: 2022年07月25日 14:53
 */
@Service
public class JobExecuteSql implements JobExecute, InitializingBean, DisposableBean {

    private static final Logger logger = LoggerFactory.getLogger(JobExecuteSql.class);

    @Autowired
    private ISysDatasourceService iSysDatasourceService;


    @Override
    public void execute(SysJobNew job) throws Exception {
        logger.info("[定时任务]执行sql:{}", job);
        ExecutSqlsInfo info = iSysDatasourceService.switchDsAndExecuteImportSql(job.getLinkTableId(), job.getInvokeTarget());
        logger.info("[定时任务]执行sql结果:{}", info);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册进入工厂
        JobExecuteFactory.register(JobEnum.EXECUTE_SQL, this);
    }

    @Override
    public void destroy() throws Exception {
        JobExecuteFactory.remove(JobEnum.EXECUTE_SQL, this);
    }
}
