package com.tbyf.his.tool.mapper;

import com.tbyf.his.tool.domain.DynamicForm;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: fr
 * @date: 2022年08月17日 11:36
 */
public interface DynamicFormMapper {
    /**
     * 查询动态单
     *
     * @param formId 动态单主键
     * @return 动态单
     */
    public DynamicForm selectDynamicFormByFormId(Long formId);

    /**
     * 查询动态单列表
     *
     * @param dynamicForm 动态单
     * @return 动态单集合
     */
    public List<DynamicForm> selectDynamicFormList(DynamicForm dynamicForm);

    /**
     * 新增动态单
     *
     * @param dynamicForm 动态单
     * @return 结果
     */
    public int insertDynamicForm(DynamicForm dynamicForm);

    /**
     * 修改动态单
     *
     * @param dynamicForm 动态单
     * @return 结果
     */
    public int updateDynamicForm(DynamicForm dynamicForm);

    /**
     * 删除动态单
     *
     * @param formId 动态单主键
     * @return 结果
     */
    public int deleteDynamicFormByFormId(Long formId);

    /**
     * 批量删除动态单
     *
     * @param formIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteDynamicFormByFormIds(Long[] formIds);

    int deleteLogic(@Param("id") Long id);

    Integer existTable(@Param("datasourceId") Long datasourceId, @Param("tableName") String tableName, @Param("formId") Long formId);

    Integer isHave(@Param("datasourceId") Long datasourceId, @Param("tableName") String tableName);
}
