package com.tbyf.his.web.controller.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseInfoModel;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.domain.ExecutSqlsInfo;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.apiconvert.service.IFieldMappingService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.sign.Base64;

import com.tbyf.his.patient360.domain.Patient360MenuInfo;
import com.tbyf.his.patient360.service.Patient360Service;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.service.ISysCommonService;
import com.tbyf.his.system.service.ISysDatasourceService;
import com.tbyf.his.tool.service.SmsService;
import com.tbyf.his.tool.vo.HisSmsVo;
import com.tbyf.his.tool.vo.SendSmsVo;
import io.swagger.annotations.ApiOperation;
import lombok.Data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/open/api")
public class OpenController extends BaseController {

    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;
    @Autowired
    private IFieldMappingService fieldMappingService;
    @Autowired
    private ISysDatasourceService sysDatasourceService;
    @Autowired
    Patient360Service patient360Service;
    @Autowired
    SmsService service;

    private static final Logger log = LoggerFactory.getLogger(OpenController.class);


    @PostMapping("/sendSms")
    public void sendSms(@RequestBody SendSmsVo sendSmsVo) {
        service.sendSms(sendSmsVo.getPhoneNumbers(), sendSmsVo.getTemplateId(), sendSmsVo.getTemplateParam(), sendSmsVo.getAppcode());
    }

    //    @PostMapping("/hipSendSms")
//    public void hipSendSms(@RequestBody HisSendSmsVo sendSmsVo){
//        service.hisSendSms(sendSmsVo);
//    }
    @PostMapping("/handlerRequestNoAuth/hipSendSms")
    public AjaxResult hisSms(@RequestBody HisSmsVo smsVo) {
        return service.hisSms(smsVo);
    }

    @ApiOperation("handlerRequestNoAuth")
    @PostMapping("/handlerRequestNoAuth")
    @Log(title = "OpenApi", businessType = BusinessType.Proxy)
    public AjaxResult handlerRequestNoAuth(@Validated @RequestBody ApiconvertBaseInfoModel model) {
        //限制apiId，只有机构和科室可以查询
        //多余多机构多数据库模式，这里把机构代码传过来，通过api数据源组和机构代码修改api的数据源
        return handlerRequest(model);
    }

    @PostMapping("/handlerRequest")
    @Log(title = "OpenApi", businessType = BusinessType.Proxy)
    //@ApiOperation("handlerRequest")
    public AjaxResult handlerRequest(@Validated @RequestBody ApiconvertBaseInfoModel model) {
        return AjaxResult.success(apiconvertBaseinfoService.handlerRequest(model));
    }

    //@ApiOperation("切换数据源执行查询返回list")
    @PostMapping("/executeSql/{datasourceId}")
    @Log(title = "数据源配置", businessType = BusinessType.OTHER)
    public AjaxResult executeSql(@PathVariable Long datasourceId, String sql) {
        List<Map<String, Object>> list = sysDatasourceService.switchDsAndExecuteSql(datasourceId, sql);
        return AjaxResult.success(list);
    }

    @PostMapping("/executeSqls/{datasourceId}")
    @Log(title = "批量执行sql", businessType = BusinessType.OTHER)
    public AjaxResult executeSqls(@PathVariable Long datasourceId, @RequestBody List<ExecutSqlsInfo> sqls) {
        List<ExecutSqlsInfo> list = sysDatasourceService.switchDsAndExecuteSqls(datasourceId, sqls);
        return AjaxResult.success(list);
    }

    //@ApiOperation("切换数据源执行ddl")
    @PostMapping("/executeDDL/{datasourceId}")
    @Log(title = "切换数据源执行ddl", businessType = BusinessType.OTHER)
    public AjaxResult executeDDL(@PathVariable Long datasourceId, String sql) {
        sysDatasourceService.executeDDL(datasourceId, sql);
        return AjaxResult.success();
    }

    @PostMapping("/handlerRequestNoAuth/getPatientAllRecordCount")
    public AjaxResult getPatientAllRecordCount(@Validated @RequestBody ApiconvertBaseInfoModel model) {
        if (model.getApiId() == 0) {
            return AjaxResult.error("AppId为空");
        }

        Long appId = model.getApiId();
        if (appId == -1) {
            String param = model.getParam();
            if (param != null) {
                log.info("传入参数:" + JSON.toJSONString(model));
            }
            Map<String, Long> mapCount = new HashMap<>();
//            ApiconvertBaseinfo apiconvertBaseinfoDataSource = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiId(appId);
//            //判断数据源组是否为空如果不为空则为多机构多数据库模式
//            if (model.getOrgCode()!= null && model.getOrgCode()!=0) {
//                if (StringUtils.isNull(apiconvertBaseinfoDataSource.getDatasourceGroup())){
//                    throw new ServiceException("多机构多数据库模式下Api数据源组不能为空");
//                }
//                SysDatasource sysDatasource = new SysDatasource();
//                sysDatasource.setDatasourceGroup(apiconvertBaseinfoDataSource.getDatasourceGroup());
//                sysDatasource.setOrgCode(model.getOrgCode());
//                List<SysDatasource> sysDatasources = sysDatasourceService.selectSysDatasourceList(sysDatasource);
//                if (sysDatasources.size() == 0){
//                    throw new ServiceException("多机构多数据库模式下未查询到数据源组");
//                }
//                apiconvertBaseinfoDataSource.setTargetDatasource(sysDatasources.get(0).getDatasourceId().toString());
//            }

            long[] ids = model.getRecordAppIds();
            List<ApiconvertBaseinfo> apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiIds(ids);
            for (ApiconvertBaseinfo baseinfo : apiconvertBaseinfo) {
                if (model.getOrgCode() != null && model.getOrgCode() != 0) {
                    if (StringUtils.isNull(baseinfo.getDatasourceGroup())) {
                        throw new ServiceException("多机构多数据库模式下Api数据源组不能为空");
                    }
                    SysDatasource sysDatasource = new SysDatasource();
                    sysDatasource.setDatasourceGroup(baseinfo.getDatasourceGroup());
                    sysDatasource.setOrgCode(model.getOrgCode());
                    List<SysDatasource> sysDatasources = sysDatasourceService.selectSysDatasourceList(sysDatasource);
                    if (sysDatasources.size() == 0) {
                        throw new ServiceException("多机构多数据库模式下未查询到数据源组");
                    }
                    baseinfo.setTargetDatasource(sysDatasources.get(0).getDatasourceId().toString());
                }
                mapCount.put("count" + baseinfo.getApiId().toString(), getCount(param, baseinfo));
            }
            return AjaxResult.success(mapCount);
        }
        return AjaxResult.error();
    }

    @GetMapping("/handlerRequestNoAuth/getPatient360Menu")
    public TableDataInfo getPatient360Manu(Patient360MenuInfo patient360MenuInfo) {
        List<Patient360MenuInfo> patient360MenuInfos = patient360Service.queryPatient360MenuList(patient360MenuInfo);
        return getDataTable(patient360MenuInfos);
    }

    private List<Map<String, Object>> getSqlExecResult(String param, ApiconvertBaseinfo apiconvertBaseinfo) {
        //先拿到传入的数据，忽略结构和映射
        JSONObject inParamJson = JSONObject.parseObject(param);
        FieldMapping fieldMapping = new FieldMapping();
        fieldMapping.setApiId(apiconvertBaseinfo.getApiId());
        fieldMapping.setParamFlag("in");
        fieldMapping.setFieldFlag("source");//直接以source为主组织sql，这里先不考虑转换
        List<FieldMapping> fieldMappings = fieldMappingService.selectFieldList(fieldMapping);
        String targetSqlText = apiconvertBaseinfo.getTargetSqltext();
        targetSqlText = Base64.decode(targetSqlText);

        for (FieldMapping mapping : fieldMappings) {
            String fieldName = mapping.getFieldName();
            String pattern1 = "#" + fieldName + "#";
            targetSqlText = targetSqlText.replace(pattern1, inParamJson.getString(fieldName));
        }
        //遍历target的数据，如果有map就取出来赋值，没有就赋null
        List<Map<String, Object>> result = sysDatasourceService.switchDsAndExecuteSql(Long.parseLong(apiconvertBaseinfo.getTargetDatasource()), targetSqlText);
        return result;
    }

    private long getCount(String param, ApiconvertBaseinfo baseinfo) {
        List<Map<String, Object>> result = getSqlExecResult(param, baseinfo);
        Map<String, Object> map = result.get(0);
        String count = map.get("count").toString();
        return Long.parseLong(count);
    }


    @Data
    static class PopRequestData {
        //字典代码
        private String popCode;
        //是否需要【带机构查询】
        private Boolean isAddOrgCode;
        //HIS界面中给出的条件语句：此内容一般为where条件部分
        private String andStr;
        //用户输入
        private String inputStr;
    }


    @PostMapping("/handlerRequestElement")
    @Log(title = "OpenApi", businessType = BusinessType.Proxy)
    //@ApiOperation("handlerRequestElement")
    public AjaxResult handlerRequestElement(@Validated @RequestBody ApiconvertBaseInfoModel model) {
        return AjaxResult.success(apiconvertBaseinfoService.handlerRequestElement(model));

    }

    @PostMapping("/handlerRequestNoAuth/createThermometer")
    @Log(title = "创建体温单", businessType = BusinessType.OTHER)
    public AjaxResult createThermometer(@RequestBody Map<String, Object> data) {
        Map<String, Object> macroElement = patient360Service.createThermometer(data);

        return AjaxResult.success(macroElement);
    }

    @PostMapping("/handlerRequestNoAuth/getHomePageTemplate")
    @Log(title = "新建首页", businessType = BusinessType.OTHER)
    public AjaxResult saveHomePage(@RequestBody Map<String, Object> data) {
        List<Map<String, Object>> macroElement = patient360Service.getHomePageTemplate(data);

        return AjaxResult.success(macroElement);
    }

    @PostMapping("handlerRequestNoAuth/handlerRequestElement")
    @Log(title = "OpenApi", businessType = BusinessType.Proxy)
    //@ApiOperation("handlerRequestElement")
    public AjaxResult openHandlerRequestElement(@Validated @RequestBody ApiconvertBaseInfoModel model) {
        return AjaxResult.success(apiconvertBaseinfoService.handlerRequestElement(model));

    }


}
