package com.tbyf.his.configuration.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * searchTable组件配置对象 st_config
 *
 * @author guopx
 * @date 2022-05-16
 */
public class StConfig extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private Long id;

    /**
     * 页面名称
     */
    @Excel(name = "页面名称")
    private String pageName;

    /**
     * 接口地址
     */
    @Excel(name = "接口地址")
    private String httpUrl;

    /**
     * 请求方式
     */
    @Excel(name = "请求方式")
    private String httpMethod;

    /**
     * 查询字段
     */
    @Excel(name = "查询字段")
    private String searchBy;

    /**
     * 选中后展示
     */
    @Excel(name = "选中后展示")
    private String returnKey;

    /**
     * 其他参数
     */
    @Excel(name = "其他参数")
    private String otherParams;

    /**
     * 是否显示表头
     */
    @Excel(name = "是否显示表头")
    private String isShowHeader;

    /**
     * $column.columnComment
     */
    @Excel(name = "是否显示表头")
    private String col2;

    /**
     * $column.columnComment
     */
    @Excel(name = "是否显示表头")
    private String col3;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getPageName() {
        return pageName;
    }

    public void setHttpUrl(String httpUrl) {
        this.httpUrl = httpUrl;
    }

    public String getHttpUrl() {
        return httpUrl;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public void setSearchBy(String searchBy) {
        this.searchBy = searchBy;
    }

    public String getSearchBy() {
        return searchBy;
    }

    public void setReturnKey(String returnKey) {
        this.returnKey = returnKey;
    }

    public String getReturnKey() {
        return returnKey;
    }

    public void setOtherParams(String otherParams) {
        this.otherParams = otherParams;
    }

    public String getOtherParams() {
        return otherParams;
    }

    public void setIsShowHeader(String isShowHeader) {
        this.isShowHeader = isShowHeader;
    }

    public String getIsShowHeader() {
        return isShowHeader;
    }

    public void setCol2(String col2) {
        this.col2 = col2;
    }

    public String getCol2() {
        return col2;
    }

    public void setCol3(String col3) {
        this.col3 = col3;
    }

    public String getCol3() {
        return col3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("pageName", getPageName())
                .append("httpUrl", getHttpUrl())
                .append("httpMethod", getHttpMethod())
                .append("remark", getRemark())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("searchBy", getSearchBy())
                .append("returnKey", getReturnKey())
                .append("otherParams", getOtherParams())
                .append("isShowHeader", getIsShowHeader())
                .append("col2", getCol2())
                .append("col3", getCol3())
                .toString();
    }
}
