package com.tbyf.his.system.vo;

import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.common.exception.ServiceException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: fr
 * @date: 2022年08月17日 15:08
 */
public class SqlHandler {

    /**
     * 查询mysql数据库所有表
     */
    private static final String MYSQL_QUERY_ALL_TABLE = "select TABLE_NAME,TABLE_COMMENT from information_schema.tables where table_schema='%s'";
    /**
     * 查询mysql数据库所有表分页
     */
    private static final String MYSQL_QUERY_ALL_TABLE_PAGE = "select TABLE_NAME,TABLE_COMMENT from information_schema.tables where table_schema='%s' and TABLE_NAME not in (%s) limit %d,%d";
    /**
     * 查询mysql数据库所有表分页过表名查询
     */
    private static final String MYSQL_QUERY_ALL_TABLE_PAGE_QUERY = "select TABLE_NAME,TABLE_COMMENT from information_schema.tables where table_schema='%s' and TABLE_NAME not in (%s) AND instr(TABLE_NAME,'%s')>0 limit %d,%d";
    /**
     * 查询oracle用户所有表
     */
    private static final String ORACLE_QUERY_ALL_TABLE = "SELECT TABLE_NAME,COMMENTS from all_tab_comments where OWNER=upper('%s')";
    /**
     * 查询oracle用户所有表分页
     */
    private static final String ORACLE_QUERY_ALL_TABLE_Page = "SELECT * FROM (SELECT temp.*,ROWNUM RN FROM (SELECT TABLE_NAME,COMMENTS from all_tab_comments where OWNER=upper('%s') AND TABLE_NAME not in (%s)) temp) WHERE  RN>%d and RN<=%d";
    /**
     * 查询oracle用户所有表分页通过表名查询
     */
    private static final String ORACLE_QUERY_ALL_TABLE_Page_QUERY = "SELECT * FROM (SELECT temp.*,ROWNUM RN FROM (SELECT TABLE_NAME,COMMENTS from all_tab_comments where OWNER=upper('%s') AND TABLE_NAME not in (%s) AND instr(TABLE_NAME,'%s')>0) temp) WHERE  RN>%d and RN<=%d";
    /**
     * 查询mysql表所有字段信息
     */
    private static final String MYSQL_QUERY_ALL_COLUMN = "SELECT COLUMN_NAME,COLUMN_COMMENT FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s'";
    /**
     * 查询oracle表所有字段信息
     */
    private static final String ORACLE_QUERY_ALL_COLUMN = "select COLUMN_NAME,COMMENTS from user_col_comments where Table_Name='%s'";
    /**
     * 查询mysql表主键字段名称
     */
    private static final String MYSQL_QUERY_TABLE_PRIMARY = "SELECT cu.Column_Name FROM INFORMATION_SCHEMA.`KEY_COLUMN_USAGE` cu WHERE CONSTRAINT_NAME 'PRIMARY' AND CONSTRAINT_SCHEMA '%s' AND cu.Table_Name = '%s' limit 1";
    /**
     * 查询oracle表主键字段名称
     */
    private static final String ORACLE_QUERY_TABLE_PRIMARY = "select col.column_name from user_constraints con,  user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P' and col.table_name = '%s'";

    private static final String ORACLE_TYPE = "oracle";
    private static final String MYSQL_TYPE = "mysql";
    /**
     * 查询模板
     */
    private static final String SELECT_SQL = "select %s from %s";
    /**
     * 等于拼接模板
     */
    private static final String EQUARL_SIGN = "%s = '%s'";

    /**
     * oracle分页查询模板，有6个变量依次是：查询字段，表名，内表where条件，终止行标，外表where条件，起始行标
     */
    private static final String ORACLE_PAGE_SELECT = "SELECT %s FROM (SELECT t.*,t.rowid ROW_X1X_ID,ROWNUM r FROM %s t WHERE %s ROWNUM <= %s) WHERE %s r >= %s";
    /**
     * mysql分页查询模板，变量依次是：查询字段，表名，where条件，起始行标，每页行数
     */
    private static final String MYSQL_PAGE_SELECT = "SELECT %s FROM %s %s limit %s,%s";
    /**
     * 查询表的总行数
     */
    private static final String SELECT_COUNT = "SELECT COUNT(1) COUNT FROM %s";
    /**
     * 插入语句
     */
    private static final String INSERT_SQL = "insert into %s (%s) values (%s)";
    /**
     * 装入值
     */
    private static final String VALUE_BOX = "'%s'";

    /**
     * 更新语句
     */
    private static final String UPDATE_SQL = "update %s set %s where %s";

    /**
     * 查询是否存在
     */
    private static final String SELECT_EXIST = "select % DATA from %s where %s = %s";

    /**
     * oracle默认的唯一字段rowid的别名
     */
    public static final String ORACLE_PRIMARY_KEY_ALIAS = "ROW_X1X_ID";
    public static final String ORACLE_PRIMARY_KEY = "ROWID";

    /**
     * 清空表所有数据
     */
    public static final String DELETE_TABLE_ALL_DATA = "truncate table %s";


    public static String getQueryAllTableSql(Boolean isOracle, String db) {
        return String.format(isOracle ? ORACLE_QUERY_ALL_TABLE : MYSQL_QUERY_ALL_TABLE, db);
    }

    public static String getQueryAllTablePageSql(Boolean isOracle, String db, String filter, int pageNum, int pageSize) {
        int Start = (pageNum - 1) * pageSize;
        int End = pageNum * pageSize;
        if (isOracle) {
            return String.format(ORACLE_QUERY_ALL_TABLE_Page, db, filter, Start, End);
        }
        return String.format(MYSQL_QUERY_ALL_TABLE_PAGE, db, filter, Start, pageSize);
    }

    public static String getQueryAllTablePageAndNameSql(Boolean isOracle, String db, String filter, String tableName, int pageNum, int pageSize) {
        if (isOracle) {
            return String.format(ORACLE_QUERY_ALL_TABLE_Page_QUERY, db, filter, tableName, (pageNum - 1) * pageSize, pageNum * pageSize);
        }
        return String.format(MYSQL_QUERY_ALL_TABLE_PAGE_QUERY, db, filter, tableName, (pageNum - 1) * pageSize, pageSize);
    }

    public static String getQueryAllColumnSql(Boolean isOracle, String db, String table) {
        String sql;
        if (isOracle) {
            sql = String.format(ORACLE_QUERY_ALL_COLUMN, table);
        } else {
            sql = String.format(MYSQL_QUERY_ALL_COLUMN, db, table);
        }
        return sql;
    }

    public static boolean isOracle(String driverClassName) {
        if (driverClassName.contains(ORACLE_TYPE)) {
            return true;
        }
        if (driverClassName.contains(MYSQL_TYPE)) {
            return false;
        }
        throw new ServiceException("未知的驱动类型：" + driverClassName);
    }

    public static String getDB(Boolean isOracle, String url, String username) {
        if (isOracle) {
            return username;
        }
        String s = StringUtils.split(url, "?")[0];
        return s.substring(s.lastIndexOf("/") + 1);
    }

    public static String createPageSelectSql(boolean isOracle, List<String> queryColumn, String tableName, List<MyKeyValue> whereColumn, Integer pageNum, Integer pageSize) {
        if (CollectionUtils.isEmpty(queryColumn)) {
            throw new ServiceException("查询字段为空");
        }
        if (StringUtils.isEmpty(tableName)) {
            throw new ServiceException("查询表名为空");
        }
        if (CollectionUtils.isEmpty(whereColumn)) {
            whereColumn = new ArrayList<>();
        }

        Integer startPage = isOracle ? getOracleStartPage(pageNum, pageSize) : getMysqlStartPage(pageNum, pageSize);
        Integer endPage = getOracleEndPage(pageNum, pageSize);

        String query = String.join(",", queryColumn);
        List<String> whereList = new ArrayList<>();
        whereColumn.forEach(d -> whereList.add(String.format(EQUARL_SIGN, d.getKey(), d.getValue())));
        String whereSql = CollectionUtils.isEmpty(whereColumn) ? "" :
                isOracle ? String.join(" and ", whereList) + " and " :
                        " where " + String.join(" and ", whereList);

        return isOracle
                ? String.format(ORACLE_PAGE_SELECT, query, tableName, whereSql, endPage, whereSql, startPage)
                : String.format(MYSQL_PAGE_SELECT, query, tableName, whereSql, startPage, pageSize);
    }

    private static Integer getOracleStartPage(Integer pageNum, Integer pageSize) {
        return (pageNum - 1) * pageSize + 1;
    }

    private static Integer getMysqlStartPage(Integer pageNum, Integer pageSize) {
        return (pageNum - 1) * pageSize;
    }

    private static Integer getOracleEndPage(Integer pageNum, Integer pageSize) {
        return pageNum * pageSize;
    }

    public static String createSelectCountSql(String tableName) {
        return String.format(SELECT_COUNT, tableName);
    }

    public static String createInsertSql(String tableName, List<MyKeyValue> param) {
        List<String> names = param.stream().map(MyKeyValue::getKey).collect(Collectors.toList());
        List<String> values = param.stream().map(d -> String.format(VALUE_BOX, d.getValue())).collect(Collectors.toList());
        String columnNameSql = String.join(",", names);
        String columnValueSql = String.join(",", values);
        return String.format(INSERT_SQL, tableName, columnNameSql, columnValueSql);
    }

    public static String createUpdateSql(String tableName, List<MyKeyValue> param, MyKeyValue primaryParam) {
        List<String> setValue = param.stream().map(d -> String.format(EQUARL_SIGN, d.getKey(), d.getValue())).collect(Collectors.toList());
        String setValueSql = String.join(",", setValue);
        String primarySql = String.format(EQUARL_SIGN, primaryParam.getKey(), primaryParam.getValue());
        return String.format(UPDATE_SQL, tableName, setValueSql, primarySql);
    }

}
