package com.tbyf.his.web.controller.adapter;

import com.tbyf.his.adapter.domain.BCodevalue;
import com.tbyf.his.adapter.service.IBCodevalueService;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.utils.SecurityUtils;
import com.tbyf.his.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Author:lph
 * Date:2022/11/18 11:43
 **/
@RestController
@RequestMapping("/platform/dictMeta/bCodevalue")
public class BCodevalueController extends BaseController {
    @Autowired
    private IBCodevalueService bCodevalueService;


    /**
     * 查询业务代码值域列表
     */
    @GetMapping("/list")
    public TableDataInfo list(@RequestParam HashMap map) {
        BCodevalue bCodevalue = new BCodevalue();
        bCodevalue.setbASECODETABLECODE((String) map.get("bASECODETABLECODE"));
        String queryName = (String) map.get("queryName");
        List<BCodevalue> list = bCodevalueService.selectBCodevalueList(bCodevalue);

        //判断条件是否为空
        if (!StringUtils.isNull(queryName)) {
            //根据条件进行过滤
            list = list.stream().filter(b -> b.getvALUECODE().contains(queryName) || b.getvALUENAME().contains(queryName))
                    .collect(Collectors.toList());
        }
        return getDataTable(list);
    }


    /**
     * 修改业务代码值域
     */
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody BCodevalue bCodevalue) {
        bCodevalue.setUpdateBy(SecurityUtils.getUsername());
        return toAjax(bCodevalueService.updateBCodevalue(bCodevalue));
    }
}
