package com.tbyf.his.web.controller.configuration;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.configuration.domain.StConfig;
import com.tbyf.his.configuration.service.IStConfigService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;

import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * searchTable组件配置Controller
 *
 * @author guopx
 * @date 2022-05-16
 */
@RestController
@RequestMapping("/st/config")
public class StConfigController extends BaseController {
    @Autowired
    private IStConfigService stConfigService;

    /**
     * 查询searchTable组件配置列表
     */
//    @PreAuthorize("@ss.hasPermi('system:config:list')")
    @GetMapping("/list")
    public TableDataInfo list(StConfig stConfig) {
        startPage();
        List<StConfig> list = stConfigService.selectStConfigList(stConfig);
        return getDataTable(list);
    }

    /**
     * 导出searchTable组件配置列表
     */
//    @PreAuthorize("@ss.hasPermi('system:config:export')")
    @Log(title = "searchTable组件配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, StConfig stConfig) {
        List<StConfig> list = stConfigService.selectStConfigList(stConfig);
        ExcelUtil<StConfig> util = new ExcelUtil<StConfig>(StConfig.class);
        util.exportExcel(response, list, "searchTable组件配置数据");
    }

    /**
     * 获取searchTable组件配置详细信息
     */
//    @PreAuthorize("@ss.hasPermi('system:config:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(stConfigService.selectStConfigById(id));
    }

    /**
     * 新增searchTable组件配置
     */
//    @PreAuthorize("@ss.hasPermi('system:config:add')")
    @Log(title = "searchTable组件配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody StConfig stConfig) {
        return toAjax(stConfigService.insertStConfig(stConfig));
    }

    /**
     * 修改searchTable组件配置
     */
//    @PreAuthorize("@ss.hasPermi('system:config:edit')")
    @Log(title = "searchTable组件配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody StConfig stConfig) {
        return toAjax(stConfigService.updateStConfig(stConfig));
    }

    /**
     * 删除searchTable组件配置
     */
//    @PreAuthorize("@ss.hasPermi('system:config:remove')")
    @Log(title = "searchTable组件配置", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(stConfigService.deleteStConfigByIds(ids));
    }
}
