package com.tbyf.his.web.controller.adapter;

import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.service.AdapterPublishTaskService;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/adapter/task")
public class AdapterPublishTaskController extends BaseController {

    @Autowired
    private AdapterPublishTaskService adapterPublishTaskService;

    @GetMapping("/list")
    public TableDataInfo getList(@RequestParam(required = false) String sourceName,
                                 @RequestParam(required = false) String publishTableName) {
        startPage();
        return getDataTable(adapterPublishTaskService.getList(sourceName, publishTableName));
    }

    /**
     * 生成增量sql、并将发布任务设置为已启动
     */
    @PostMapping("/startUp")
    public AjaxResult startUp(@RequestBody List<Long> ids) {
        adapterPublishTaskService.startUp(ids);
        return AjaxResult.success();
    }

    /**
     * 停止任务
     */
    @PostMapping("/stop")
    public AjaxResult stop(@RequestBody List<Long> ids) {
        adapterPublishTaskService.stop(ids);
        return AjaxResult.success();
    }

    /**
     * 查询发布任务
     */
    @GetMapping("/getInfo")
    public AjaxResult getInfo(@RequestParam("publishTableName") String publishTableName,
                              @RequestParam("sourceName") String sourceName) {
        AdapterPublishTask adapterPublishTask = adapterPublishTaskService.selectTaskByPublishTableNameAndSourceName(publishTableName, sourceName);
        return AjaxResult.success(adapterPublishTask);
    }

    @PutMapping("/update")
    public AjaxResult update(@RequestBody AdapterPublishTask adapterPublishTask) {
        return toAjax(adapterPublishTaskService.updateAdapterPublishTask(adapterPublishTask));
    }
}
