package com.tbyf.his.web.dataImport.core;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lzz
 * @date 2023/2/9 9:22
 */
@Configuration
public class DiConfig {

    @Autowired
    private ApplicationContext applicationContext;

    public static final Map<String, RuleValidator> VALIDATOR_MAP = new ConcurrentHashMap<>(8);

    @PostConstruct
    public void init() {
        final Map<String, RuleValidator> validatorMap = applicationContext.getBeansOfType(RuleValidator.class);
        VALIDATOR_MAP.putAll(validatorMap);
    }

    /**
     * 获取校验器
     *
     * @param mode
     * @return
     */
    public static RuleValidator getValidator(String mode) {
        return VALIDATOR_MAP.get(DiConstants.SERVICE_PREFIX + mode);
    }

}
