package com.tbyf.his.apiconvert.service.impl;

import com.tbyf.his.apiconvert.domain.Plugin;
import com.tbyf.his.apiconvert.mapper.PluginMapper;
import com.tbyf.his.apiconvert.service.IPluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class IPluginServiceImpl implements IPluginService {

    @Autowired
    private PluginMapper pluginMapper;

    @Override
    public int insertPlugin(Plugin plugin) {
        return pluginMapper.insertPlugin(plugin);
    }

    @Override
    public int updatePlugin(Plugin plugin) {
        return pluginMapper.updatePlugin(plugin);
    }

    @Override
    public int deletePluginById(long pluginId) {
        return pluginMapper.deletePluginById(pluginId);
    }

    @Override
    public Plugin queryPluginById(long pluginId) {
        return pluginMapper.queryPluginById(pluginId);
    }

    @Override
    public List<Plugin> queryAll() {
        return pluginMapper.queryAll();
    }

    @Override
    public List<Plugin> queryLike(Plugin plugin) {
        return pluginMapper.queryLike(plugin);
    }
}
