create table data_dict
(
    id      varchar(32) not null
        primary key,
    type    varchar(32) null comment '字典类型',
    label   varchar(256) null comment '标签',
    value   varchar(64) null comment '数据值',
    remarks text null comment '备注'
) comment '数据字典';


create table data_import_template
(
    id            varchar(32) not null
        primary key,
    name          varchar(256) null comment '模板名称',
    org_name      varchar(64) null comment '机构类型',
    import_status varchar(32) null comment '导入状态 1-已导入 0-未导入',
    year          varchar(32) null comment '数据年份',
    import_time   timestamp null comment '上次导入时间',
    datasource_id varchar(32) null comment '数据源ID',
    table_name    varchar(32) null comment '表名',
    create_time   timestamp null comment '创建时间',
    update_time   timestamp null comment '更新时间',
    remarks       text null comment '备注'
) comment '数据导入模板表';

create table data_field
(
    id          varchar(32) not null
        primary key,
    template_id varchar(32) null comment '模板ID',
    code        varchar(256) null comment '代码',
    title       varchar(256) null comment '指标名称',
    unit        varchar(32) null comment '计量单位',
    coordinate  varchar(32) null comment '数据起始坐标,例如 C,4',
    sort        int default 0 comment '排序字段',
    field       varchar(32) null comment '数据库字段名'
) comment '数据字段表';

create table data_rule
(
    id      varchar(32) not null primary key,
    name    varchar(64) null comment '规则名称',
    type    varchar(64) null comment '规则类型 1-基础规则 2-组合规则 3-字段复合规则',
    mode    varchar(64) null comment '规则验证模式',
    content varchar(256) null comment '规则验证内容',
    remarks text null comment '备注'
) comment '数据规则表';

create table bind_rule
(
    data_id varchar(32) null comment '数据ID',
    rule_id varchar(32) null comment '规则ID'
) comment '规则绑定表';

create table excel_data
(
    id          varchar(32) not null primary key,
    file_name   varchar(64) null comment '文件名',
    file        longblob null comment '文件数据',
    type        varchar(64) null comment '文件类型 1-初始导入文件 2-标准模板文件',
    template_id varchar(32) null comment '模板ID',
    year        varchar(32) null comment '数据年份',
    org_name    varchar(64) null comment '机构类型',
) comment 'excel存储表';

