package com.tbyf.his.web.dataImport.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.domain.param.QueryTemplateParam;
import com.tbyf.his.web.dataImport.domain.vo.TemplateVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataImportTemplate;
import com.tbyf.his.web.dataImport.mapper.DataImportTemplateMapper;
import com.tbyf.his.web.dataImport.service.DataImportTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class DataImportTemplateServiceImpl extends ServiceImpl<DataImportTemplateMapper, DataImportTemplate> implements DataImportTemplateService {

    @Autowired
    private DataImportTemplateMapper dataImportTemplateMapper;

    @Override
    public List<TemplateVO> queryTemplate(QueryTemplateParam param) {
        return dataImportTemplateMapper.queryTemplate(param);
    }

    @Override
    public DbType getDbType(String dataSourceId) {
        final String dbType = dataImportTemplateMapper.queryDbType(dataSourceId);
        if (StringUtils.isBlank(dbType)) {
            return DbType.MYSQL;
        }
        if (dbType.toUpperCase().contains("MYSQL")) {
            return DbType.MYSQL;
        } else {
            return DbType.ORACLE;
        }
    }

    @Override
    public List<VerifyVO> getVerify(String id) {
        return dataImportTemplateMapper.getVerify(id);
    }
}
