package com.tbyf.his.apiconvert.service;

import com.tbyf.his.apiconvert.domain.FieldMap;
import com.tbyf.his.apiconvert.domain.model.SourceAndTarget;
import com.tbyf.his.common.core.domain.entity.FieldMapping;
import com.tbyf.his.common.core.domain.TreeSelect;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 字段管理 服务层
 *
 * @author 郭鹏翔
 */
public interface IFieldMappingService {
    /**
     * 查询字段管理数据
     *
     * @param field 字段信息
     * @return 字段信息集合
     */
    public List<FieldMapping> selectFieldList(FieldMapping field);

    public List<FieldMapping> selectConnectTo(FieldMapping field);

    /**
     * 构建前端所需要树结构
     *
     * @param fields 字段列表
     * @return 树结构列表
     */
    public List<FieldMapping> buildFieldTree(List<FieldMapping> fields);

    /**
     * 构建前端所需要下拉树结构
     *
     * @param fields 字段列表
     * @return 下拉树结构列表
     */
    public List<TreeSelect> buildFieldTreeSelect(List<FieldMapping> fields);

    /**
     * 根据字段ID查询信息
     *
     * @param fieldId 字段ID
     * @return 字段信息
     */
    public FieldMapping selectFieldById(Long fieldId);

    /**
     * 根据ID查询所有子字段（正常状态）
     *
     * @param fieldId 字段ID
     * @return 子字段数
     */
    public int selectNormalChildrenFieldById(Long fieldId);

    /**
     * 是否存在字段子节点
     *
     * @param fieldId 字段ID
     * @return 结果
     */
    public boolean hasChildByFieldId(Long fieldId);

    /**
     * 校验字段名称是否唯一
     *
     * @param field 字段信息
     * @return 结果
     */
    public String checkFieldNameUnique(FieldMapping field);

    /**
     * 新增保存字段信息
     *
     * @param field 字段信息
     * @return 结果
     */
    public int insertField(FieldMapping field);

    /**
     * 修改保存字段信息
     *
     * @param field 字段信息
     * @return 结果
     */
    public int updateField(FieldMapping field);

    /**
     * 删除字段管理信息
     *
     * @param fieldId 字段ID
     * @return 结果
     */
    public int deleteFieldById(Long fieldId);

    public int insertFieldMap(FieldMap field);

    public int deleteFieldMap(Long sourceFieldId, Long targetFieldId, Long apiBaseinfoId);

    List<FieldMap> selectFieldMappingByApiId(Long apiId);

}
