package com.tbyf.his.system.domain;

import com.tbyf.his.common.core.domain.BaseEntity;
import com.tbyf.his.common.core.domain.entity.SysDept;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.tbyf.his.common.annotation.Excel;

import java.util.ArrayList;
import java.util.List;

/**
 * 插件种类对象 sys_category
 *
 * @author guoxw
 */
public class SysCategory extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 插件种类id
     */
    private Long categoryId;

    /**
     * 父部门ID
     */
    private Long parentId;

    /**
     * 祖级列表
     */
    private String ancestors;

    /**
     * 种类名称
     */
    @Excel(name = "种类名称")
    private String categoryName;

    /**
     * 删除标志（0代表存在 2代表删除）
     */
    private String delFlag;

    /**
     * 父插件种类名称
     */
    private String parentName;

    /**
     * 子插件种类
     */
    private List<SysCategory> children = new ArrayList<SysCategory>();

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getAncestors() {
        return ancestors;
    }

    public void setAncestors(String ancestors) {
        this.ancestors = ancestors;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setDelFlag(String delFlag) {
        this.delFlag = delFlag;
    }

    public String getDelFlag() {
        return delFlag;
    }

    public String getParentName() {
        return parentName;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public List<SysCategory> getChildren() {
        return children;
    }

    public void setChildren(List<SysCategory> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("categoryId", getCategoryId())
                .append("parentId", getParentId())
                .append("ancestors", getAncestors())
                .append("categoryName", getCategoryName())
                .append("delFlag", getDelFlag())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .toString();
    }

}
