package com.tbyf.his.system.service;

import java.util.List;

import com.tbyf.his.common.core.domain.TreeSelect;
import com.tbyf.his.common.core.domain.entity.SysMenu;
import com.tbyf.his.common.utils.tree.Tree;
import com.tbyf.his.system.domain.SysModule;
import org.springframework.data.repository.query.Param;

/**
 * 应用模块管理Service接口
 *
 * @author zq
 * @date 2022-05-30
 */
public interface ISysModuleService {
    /**
     * 查询应用模块管理
     *
     * @param moduleId 应用模块管理主键
     * @return 应用模块管理
     */
    public SysModule selectSysModuleByModuleId(Long moduleId);

    /**
     * 查询应用模块管理列表
     *
     * @param sysModule 应用模块管理
     * @return 应用模块管理集合
     */
    public List<SysModule> selectSysModuleList(SysModule sysModule);

    /**
     * 新增应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    public int insertSysModule(SysModule sysModule);

    /**
     * 修改应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    public int updateSysModule(SysModule sysModule);

    /**
     * 批量删除应用模块管理
     *
     * @param moduleIds 需要删除的应用模块管理主键集合
     * @return 结果
     */
    public int deleteSysModuleByModuleIds(Long[] moduleIds);

    /**
     * 删除应用模块管理信息
     *
     * @param moduleId 应用模块管理主键
     * @return 结果
     */
    public int deleteSysModuleByModuleId(Long moduleId);

    /**
     * @param modules
     * @return
     */
    public List<Tree<SysModule>> buildModuleTreeSelect(List<SysModule> modules);

    public List<SysModule> buildModuleTree(List<SysModule> modules);

    /**
     * 查询要删除的项目是否有下级菜单
     *
     * @param moduleId
     * @return
     */
    public boolean hasChildByModuleId(Long moduleId);

    /**
     * 判断查询的的数据是否唯一
     *
     * @param
     * @return
     */
    public String checkMenuNameUnique(SysModule sysModule);

}
