package com.tbyf.his.configuration.mapper;

import com.tbyf.his.configuration.domain.WsConfig;

import java.util.List;


/**
 * webService服务配置Mapper接口
 *
 * @author guopx
 * @date 2022-04-14
 */
public interface WsConfigMapper {
    /**
     * 查询webService服务配置
     *
     * @param id webService服务配置主键
     * @return webService服务配置
     */
    public WsConfig selectWsConfigById(Long id);

    /**
     * 查询webService服务配置列表
     *
     * @param wsConfig webService服务配置
     * @return webService服务配置集合
     */
    public List<WsConfig> selectWsConfigList(WsConfig wsConfig);

    /**
     * 新增webService服务配置
     *
     * @param wsConfig webService服务配置
     * @return 结果
     */
    public int insertWsConfig(WsConfig wsConfig);

    /**
     * 修改webService服务配置
     *
     * @param wsConfig webService服务配置
     * @return 结果
     */
    public int updateWsConfig(WsConfig wsConfig);

    /**
     * 删除webService服务配置
     *
     * @param id webService服务配置主键
     * @return 结果
     */
    public int deleteWsConfigById(Long id);

    /**
     * 批量删除webService服务配置
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteWsConfigByIds(Long[] ids);

    /**
     * 根据moduleId查询服务配置
     *
     * @param moduleId
     * @return
     */
    public List<WsConfig> selectWsConfigByModuleId(Long moduleId);
}
