package com.tbyf.his.system.service;

import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.system.domain.SysPlugin;
import com.tbyf.his.system.vo.PluginFileVO;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.util.List;

public interface ISysPluginService {

    /**
     * 根据条件分页查询插件列表
     *
     * @param plugin 插件信息
     * @return 用户信息集合信息
     */
    public List<SysPlugin> selectPluginList(SysPlugin plugin);


    /**
     * 通过插件名查询插件
     *
     * @param pluginName 用户名
     * @return 插件对象信息
     */
    public SysPlugin selectPluginByPluginName(String pluginName);

    /**
     * 通过插件ID查询插件
     *
     * @param pluginId 插件ID
     * @return 插件对象信息
     */
    public SysPlugin selectPluginById(Long pluginId);

    /**
     * 校验插件名称是否唯一
     *
     * @param pluginName 插件名称
     * @return 结果
     */
    public String checkPluginNameUnique(String pluginName);

    /**
     * 新增插件信息
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int insertPlugin(SysPlugin plugin);

    /**
     * 修改插件信息
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int updatePlugin(SysPlugin plugin);

    /**
     * 修改插件状态
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int updatePluginStatus(SysPlugin plugin);

    /**
     * 修改插件基本信息
     *
     * @param plugin 插件信息
     * @return 结果
     */
    public int updatePluginProfile(SysPlugin plugin);

    /**
     * 通过插件ID删除插件
     *
     * @param pluginId 插件ID
     * @return 结果
     */
    public int deletePluginById(Long pluginId);

    /**
     * 批量删除插件信息
     *
     * @param pluginIds 需要删除的插件ID
     * @return 结果
     */
    public int deletePluginByIds(Long[] pluginIds);

    /**
     * 导入插件数据
     *
     * @param pluginList      插件数据列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @param operName        操作用户
     * @return 结果
     */
    public String importPlugin(List<SysPlugin> pluginList, Boolean isUpdateSupport, String operName);

    /**
     * 异步上传文件
     *
     * @param file
     */
    PluginFileVO uploadFile(MultipartFile file);

    /**
     * 根据id获取插件文件
     *
     * @param pluginId
     * @return
     */
    File getLocalFile(Long pluginId);

    /**
     * 根据种类获取所有插件
     *
     * @param categoryId
     * @return
     */
    List<MyKeyValue> getOptionByCategory(Long categoryId);
}
