package com.tbyf.his.web.dataImport;

import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author lzz
 * @date 2023/2/17 16:01
 */

public class DataImportUtils {

    /**
     * 比较两个字符串的相识度
     * 核心算法：用一个二维数组记录每个字符串是否相同，如果相同记为0，不相同记为1，每行每列相同个数累加
     * 则数组最后一个数为不相同的总数，从而判断这两个字符的相识度
     *
     * @param str
     * @param target
     * @return
     */
    private static int compare(String str, String target) {
        int d[][];              // 矩阵
        int n = str.length();
        int m = target.length();
        int i;                  // 遍历str的
        int j;                  // 遍历target的
        char ch1;               // str的
        char ch2;               // target的
        int temp;               // 记录相同字符,在某个矩阵位置值的增量,不是0就是1
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        d = new int[n + 1][m + 1];
        // 初始化第一列
        for (i = 0; i <= n; i++) {
            d[i][0] = i;
        }
        // 初始化第一行
        for (j = 0; j <= m; j++) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; i++) {
            // 遍历str
            ch1 = str.charAt(i - 1);
            // 去匹配target
            for (j = 1; j <= m; j++) {
                ch2 = target.charAt(j - 1);
                if (ch1 == ch2 || ch1 == ch2 + 32 || ch1 + 32 == ch2) {
                    temp = 0;
                } else {
                    temp = 1;
                }
                // 左边+1,上边+1, 左上角+temp取最小
                d[i][j] = min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + temp);
            }
        }
        return d[n][m];
    }


    /**
     * 获取最小的值
     */
    private static int min(int one, int two, int three) {
        return (one = one < two ? one : two) < three ? one : three;
    }

    /**
     * 获取两字符串的相似度
     */
    public static float getSimilarityRatio(String str, String target) {
        int max = Math.max(str.length(), target.length());
        return 1 - (float) compare(str, target) / max;
    }

    public static final AtomicLong NEXT = new AtomicLong(100000);

    /**
     * 获取16位唯一id 一秒少于100000条就可以
     *
     * @return
     */
    public static synchronized String getNextId() {
        if (NEXT.get() >= 999998) {
            NEXT.set(100000);
        }
        return System.currentTimeMillis() / 1000 + "" + NEXT.getAndIncrement();
    }


    /**
     * 获取插入值的格式化形式
     *
     * @param vo
     * @return
     */
    public static String getInsertContent(VerifyVO vo, int index) {
        if (StringUtils.containsIgnoreCase(vo.getFieldType(), "VARCHAR")) {
            return "'" + vo.getValues().get(index) + "'";
        } else if (StringUtils.containsIgnoreCase(vo.getFieldType(), "NUMBER")) {
            // 判断是否是number类型
            //verifyNumber(vo,index);
            return "'" + vo.getValues().get(index) + "'";
        } else if (StringUtils.containsIgnoreCase(vo.getFieldType(), "DATE")) {
            try {
                final Date date = DateUtils.parseDate(vo.getValues().get(index), "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM",
                        "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM",
                        "yyyy.MM.dd", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM", "HH:mm");
                if (date != null) {
                    return StrFormatter.format("to_date('{}','YYYY-MM-DD HH24:MI:SS')", DateUtils.parseDateToStr("yyyy-MM-dd HH:mm:ss", date));
                }
            } catch (Exception ignore) {
            }
            return "null";
        }
        return "'" + vo.getValues().get(index) + "'";
    }

    /**
     * 校验数字
     * @param vo
     * @param index
     */
    public static void verifyNumber(VerifyVO vo, int index){
        String s = vo.getValues().get(index);
        if (StringUtils.isBlank(s)){
            throw new RuntimeException(StringUtils.format("指标:{}|{}字段:{}的数据为:{},不符合数字要求",
                    vo.getCode(),vo.getTitle(),vo.getFieldName(),s));
        }
        if (!NumberUtils.isCreatable(s)){
            throw new RuntimeException(StringUtils.format("指标:{}|{}字段:{}的数据为:{},不符合数字要求",
                    vo.getCode(),vo.getTitle(),vo.getFieldName(),s));
        }
        if (StringUtils.contains(s,".")){
            int i = s.indexOf(".");
            i = s.length() - i - 1;
            if (StringUtils.containsIgnoreCase(vo.getFieldType(), "(")){
                int start = vo.getFieldType().indexOf("(");
                int end = vo.getFieldType().indexOf(")");
                String col = vo.getFieldType().substring(start + 1, end);
                String[] split = col.split(",");
                if (split.length == 2){
                    String length = split[1];
                    if (i > Integer.parseInt(length)){
                        throw new RuntimeException(StringUtils.format("指标:{}|{}字段:{}的数据为:{},不符合数字精度要求",
                                vo.getCode(),vo.getTitle(),vo.getFieldName(),s));
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(NumberUtils.isCreatable("1.2x"));
    }

    public static String str(Object o) {
        return o == null ? StringUtils.EMPTY : o.toString();
    }

}
