package com.tbyf.his.web.dataImport.domain.param;

import com.tbyf.his.web.dataImport.domain.ParamMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;

/**
 * @author lzz
 * @date 2023/1/10 17:01
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@ApiModel(value = "字段查询参数", description = "字段查询参数")
public class QueryFieldParam extends ParamMp {

    @NotBlank(message = "templateId不能传空")
    @ApiModelProperty(value = "模板ID")
    private String templateId;

    @ApiModelProperty(value = "代码")
    private String code;

    @ApiModelProperty(value = "指标名称")
    private String title;

    @ApiModelProperty(value = "数据坐标")
    private String coordinate;

    @ApiModelProperty(value = "数据库字段名")
    private String field;

    private String oldTemplateId;

}
