package com.tbyf.his.system.service;


import com.tbyf.his.system.domain.SysApplication;

import java.util.List;

/**
 * 应用管理Service接口
 *
 * @author ruoyi
 * @date 2022-03-17
 */
public interface ISysApplicationService {
    /**
     * 查询应用管理
     *
     * @param id 应用管理主键
     * @return 应用管理
     */
    public SysApplication selectSysApplicationById(Long id);

    /**
     * 查询应用管理列表
     *
     * @param sysApplication 应用管理
     * @return 应用管理集合
     */
    public List<SysApplication> selectSysApplicationList(SysApplication sysApplication);

    /**
     * 新增应用管理
     *
     * @param sysApplication 应用管理
     * @return 结果
     */
    public int insertSysApplication(SysApplication sysApplication);

    /**
     * 修改应用管理
     *
     * @param sysApplication 应用管理
     * @return 结果
     */
    public int updateSysApplication(SysApplication sysApplication);

    /**
     * 批量删除应用管理
     *
     * @param ids 需要删除的应用管理主键集合
     * @return 结果
     */
    public int deleteSysApplicationByIds(Long[] ids);

    /**
     * 删除应用管理信息
     *
     * @param id 应用管理主键
     * @return 结果
     */
    public int deleteSysApplicationById(Long id);
}
