package com.tbyf.his.tool.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author: fr
 * @date: 2022年08月17日 11:35
 */
public class DynamicForm extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 任务ID
     */
    private Long formId;

    /**
     * 任务名称
     */
    @Excel(name = "任务名称")
    private String formName;

    /**
     * 数据源id
     */
    @Excel(name = "数据源id")
    private Long datasourceId;

    /**
     * 数据源id
     */
    @Excel(name = "数据源id")
    private String tableName;

    /**
     * json表单内容
     */
    @Excel(name = "json表单内容")
    private String formContent;

    /**
     * 是否有效：0有效1已删除
     */
    @Excel(name = "是否有效：0有效1已删除")
    private Integer isDelete;

    /**
     * 部门id
     */
    private Long deptId;

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public void setFormId(Long formId) {
        this.formId = formId;
    }

    public Long getFormId() {
        return formId;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFormName() {
        return formName;
    }

    public void setDatasourceId(Long datasourceId) {
        this.datasourceId = datasourceId;
    }

    public Long getDatasourceId() {
        return datasourceId;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setFormContent(String formContent) {
        this.formContent = formContent;
    }

    public String getFormContent() {
        return formContent;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("formId", getFormId())
                .append("formName", getFormName())
                .append("datasourceId", getDatasourceId())
                .append("tableName", getTableName())
                .append("formContent", getFormContent())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("remark", getRemark())
                .append("isDelete", getIsDelete())
                .toString();
    }
}
