package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 区间规则校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_SECTION)
@Slf4j
public class SectionValidator implements RuleValidator {

    @Override
    public void validate(RuleVO rule) {
        try {
            if (StringUtils.isNotBlank(rule.getContent())) {
                final String[] section = rule.getContent().split(DiConstants.SEPARATOR);
                final BigDecimal a = new BigDecimal(section[0]);
                final BigDecimal b = new BigDecimal(section[1]);
                final BigDecimal value = new BigDecimal(rule.getValue());
                if (value.compareTo(a) >= 0) {
                    if (b.compareTo(value) < 0) {
                        rule.setResult(StringUtils.format("区间校验未通过,数据大于{}", b.toString()));
                    }
                } else {
                    rule.setResult(StringUtils.format("区间校验未通过,数据小于{}", a.toString()));
                }
            }
        } catch (Exception e) {
            log.error("区间校验未通过", e);
            rule.setResult(StringUtils.format("区间校验 {} 未通过", rule.getName()));
        }
    }
}
