package com.tbyf.his.system.service;

import com.tbyf.his.apiconvert.domain.ExecutSqlsInfo;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.system.domain.SysDataTableVo;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.vo.DynamicSqlData;

import java.util.List;
import java.util.Map;

/**
 * 数据源配置Service接口
 *
 * @author guopx
 * @date 2022-03-01
 */
public interface ISysDatasourceService {
    /**
     * 查询数据源配置
     *
     * @param datasourceId 数据源配置主键
     * @return 数据源配置
     */
    public SysDatasource selectSysDatasourceByDatasourceId(Long datasourceId);

    SysDatasource selectSysDatasourceByDsName(String dsName);

    /**
     * 查询数据源配置列表
     *
     * @param sysDatasource 数据源配置
     * @return 数据源配置集合
     */
    public List<SysDatasource> selectSysDatasourceList(SysDatasource sysDatasource);

    /**
     * 新增数据源配置
     *
     * @param sysDatasource 数据源配置
     * @return 结果
     */
    public int insertSysDatasource(SysDatasource sysDatasource);

    /**
     * 修改数据源配置
     *
     * @param sysDatasource 数据源配置
     * @return 结果
     */
    public int updateSysDatasource(SysDatasource sysDatasource);

    /**
     * 批量删除数据源配置
     *
     * @param datasourceIds 需要删除的数据源配置主键集合
     * @return 结果
     */
    public int deleteSysDatasourceByDatasourceIds(Long[] datasourceIds);

    /**
     * 删除数据源配置信息
     *
     * @param datasourceId 数据源配置主键
     * @return 结果
     */
    public int deleteSysDatasourceByDatasourceId(Long datasourceId);

    /**
     * 查询具有适配器标识的数据源树列表
     */
    public List<MyKeyValue> selectSysDatasource();

    /**
     * 切换数据源执行sql
     *
     * @param datasourceId 数据源id
     * @param sql          执行sql
     * @return 结果
     */
    List<Map<String, Object>> switchDsAndExecuteSql(Long datasourceId, String sql);

    void executeDDL(Long datasourceId, String sql);

    List<ExecutSqlsInfo> switchDsAndExecuteSqls(Long datasourceId, List<ExecutSqlsInfo> sqls);

    /**
     * 切换数据源并执行外部导入的sql
     *
     * @param datasourceId
     * @param sql
     * @return
     */
    ExecutSqlsInfo switchDsAndExecuteImportSql(Long datasourceId, String sql);

    /**
     * 根据数据源获取所有表
     *
     * @param id
     * @return
     */
    Map<String, Object> getTablesBySourceId(Long id);

    /**
     * 测试数据库连通性
     */
    void testConnectBySourceId(SysDatasource sysDatasource);

    /**
     * 根据数据源和表名获取表
     *
     * @param sysDataTableVo
     * @return
     */
    Map<String, Object> getTablesBySourceIdAndTableName(SysDataTableVo sysDataTableVo);

    /**
     * 根据表明获取所有列名
     *
     * @param id
     * @param tableName
     * @return
     */
    List<MyKeyValue> getColumnsByTableName(Long id, String tableName);

    TableDataInfo selectPageByParam(DynamicSqlData dynamicSqlData);

    void saveByParam(DynamicSqlData dynamicSqlData);

    void saveBatchByParam(List<DynamicSqlData> list, Boolean isCover);

    void deleteByParam(DynamicSqlData dynamicSqlData);

}
