package com.tbyf.his.web.controller.analysis;

import com.tbyf.his.analysis.domain.*;
import com.tbyf.his.analysis.service.AnalysisService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 数据质量监控
 *
 * @author guopx
 * @date 2021-01-15
 */
@RestController
@RequestMapping("/platform/analysis")
public class AnalysisController extends BaseController {
    /**
     * 查询数据质量监控接入信息列表
     */
    @Autowired
    private AnalysisService analysisService;

    @GetMapping("/list")
    public TableDataInfo list(Analysis applyAnalog) {
        startPage();
        List<Analysis> list = analysisService.selectAnalysisInfo(applyAnalog);
        return getDataTable(list);
    }

    /**
     * 新增数据质量监控api信息
     *
     * @param analysis
     * @return
     */
    @PostMapping
    @Log(title = "数据监控接入api信息", businessType = BusinessType.INSERT)
    public AjaxResult add(@RequestBody Analysis analysis) {
        return toAjax(analysisService.insterAnalysisInfo(analysis));
    }

    /**
     * 删除数据质量监控api信息
     *
     * @param analysis
     * @return
     */
    @PostMapping("/del")
    @Log(title = "数据监控删除api信息", businessType = BusinessType.DELETE)
    public AjaxResult deletes(@RequestBody List<Analysis> analysis) {
        return toAjax(analysisService.removeAnalysisInfo(analysis));
    }

    @GetMapping("/businessData")
    @Log(title = "数据监控删除api信息", businessType = BusinessType.DELETE)
    public TableDataInfo getAnalysisBusinessData(AnalysisBusinessDataInfo analysisInfo) {
        startPage();
        List<AnalysisBusinessDataInfo> list = analysisService.selectAnalysisBusinessData(analysisInfo);
        return getDataTable(list);
    }

    //获取已配置api的数据集
    @GetMapping("/businessDataHaveApi")
    public TableDataInfo getAnalysisBusinessDataHaveApi(AnalysisBusinessDataInfo analysisInfo) {
        startPage();
        List<AnalysisBusinessDataInfo> list = analysisService.selectAnalysisBusinessDataHaveApi(analysisInfo);
        return getDataTable(list);
    }

    /**
     * 数据监控一致性获取数据集树
     *
     * @return
     */
    //获取全部
    @GetMapping("/businessDataTree")
    public AjaxResult getAnalysisBusinessDataTree() {
        List<IdLabel> list = new ArrayList<>();
        IdLabel ib = new IdLabel("-1", "数据集");
        ib.setChildren(analysisService.selectAnalysisBusinessDataTree());
        list.add(ib);
        return AjaxResult.success(list);
    }

    //获取绑定api的
    @GetMapping("/businessDataTreeHaveApi")
    public AjaxResult getAnalysisBusinessDataTreeHave() {
        List<IdLabel> list = new ArrayList<>();
        IdLabel ib = new IdLabel("-1", "数据集");
        ib.setChildren(analysisService.selectAnalysisBusinessDataTreeHaveApi());
        list.add(ib);
        return AjaxResult.success(list);
    }

    //获取没有绑定api的
    @GetMapping("/businessDataTreeNoApi")
    public AjaxResult getAnalysisBusinessDataTreeNo() {
        List<IdLabel> list = new ArrayList<>();
        IdLabel ib = new IdLabel("-1", "数据集");
        ib.setChildren(analysisService.selectAnalysisBusinessDataTreeNoApi());
        list.add(ib);
        return AjaxResult.success(list);
    }

    @GetMapping("/getAnalysisDataByGroupId/{dataGroupId}")
    public AjaxResult getAnalysisDataByGroupId(@PathVariable("dataGroupId") String dataGroupId) {
        List<Analysis> analyses = analysisService.selectAnalysisDataByGroupId(dataGroupId);

        return new AjaxResult(200, "success", analyses);
    }

    /**
     * 数据监控一致性获取一致性结果数据
     *
     * @param
     * @return
     */
    @PostMapping("/getAnalysisDataInfo")
    public TableDataInfo getAnalysisDataInfo(@RequestBody ConsistentData consistentData) {
        System.out.println(consistentData.getStartDate());
        List<ConsistentData> list = analysisService.selectAnalysisDataInfo(consistentData);
        return getDataTable(list);
    }

    @GetMapping("/getAnalysisMassageInfo")
    public TableDataInfo getAnalysisMassageInfo(AnalyMassageInfo analyMassageInfo) {
        startPage();
        List<AnalyMassageInfo> analyMassageInfos = analysisService.selectAnalysisMassageInfo(analyMassageInfo);
        return getDataTable(analyMassageInfos);
    }

    @PostMapping("/addAnalysisMassage")
    public AjaxResult addAnalysisMassage(@RequestBody AnalyMassageInfo analyMassageInfo) {
        int i = analysisService.insterAnalysisMassage(analyMassageInfo);
        return toAjax(i);
    }

    @PostMapping("/changeAnalysisMassage")
    public AjaxResult changeAnalysisMassage(@RequestBody AnalyMassageInfo analyMassageInfo) {
        int i = analysisService.updateAnalysisMassage(analyMassageInfo);
        return toAjax(i);
    }

    @PostMapping("/delAnalysisMassage")
    public AjaxResult delAnalysisMassage(@RequestBody AnalyMassageInfo analyMassageInfo) {
        int i = analysisService.removeAnalysisMassage(analyMassageInfo);
        return toAjax(i);
    }

}
