package com.tbyf.his.web.controller.dataImport;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.exception.base.BaseException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.framework.datasource.DynamicDataSourceContextHolder;
import com.tbyf.his.system.domain.SysDatasource;
import com.tbyf.his.system.service.ISysDatasourceService;
import com.tbyf.his.system.vo.SqlHandler;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.domain.vo.CreateFieldVO;
import com.tbyf.his.web.dataImport.domain.vo.TemplateVO;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.entity.ExcelData;
import com.tbyf.his.web.dataImport.service.DataFieldService;
import com.tbyf.his.web.dataImport.service.DataSourceService;
import com.tbyf.his.web.dataImport.service.DataTemplateService;
import com.tbyf.his.web.dataImport.service.ExcelDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/7 10:42
 */
@RestController
@Api(tags = "数据导入接口")
@RequestMapping("/data/import")
@Slf4j
public class DataImportController {

    @Autowired
    private DataTemplateService dataTemplateService;
    @Autowired
    private ISysDatasourceService sysDatasourceService;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private DataFieldService dataFieldService;

    @Autowired
    private ExcelDataService excelDataService;

    @IgnoreWebSecurity
    @GetMapping("/datasource")
    @ApiOperation("查询所有数据源")
    public AjaxResult queryDatasource() {
        final List<SysDatasource> list = sysDatasourceService.selectSysDatasourceList(new SysDatasource());
        return AjaxResult.success(list);
    }

    @IgnoreWebSecurity
    @GetMapping("/datasource/table")
    @ApiOperation("获取指定数据源中的表")
    public AjaxResult getDbTable(@RequestParam String dataSourceId) {
        try {
            DataSourceService.switchDb(dataSourceId);
            final DruidDataSource dataSource = (DruidDataSource) DynamicDataSourceContextHolder.dataSourcesMap.get(dataSourceId);
            String sql;
            if (SqlHandler.isOracle(dataSource.getDriverClassName())) {
                sql = "SELECT TABLE_NAME AS VALUE,COMMENTS AS LABEL FROM USER_TAB_COMMENTS WHERE TABLE_TYPE = 'TABLE'";
            } else {
                sql = "select TABLE_NAME  AS VALUE,TABLE_COMMENT AS LABEL from information_schema.tables where table_type='BASE TABLE'";
            }
            final List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
            return AjaxResult.success(maps.stream().filter(
                    distinctByKey(b -> b.get("VALUE"))
            ).distinct().collect(Collectors.toList()));
        } finally {
            DataSourceService.switchDefault();
        }
    }

    @IgnoreWebSecurity
    @GetMapping("/datasource/field")
    @ApiOperation("获取指定数据表中的字段")
    public AjaxResult getDbField(@RequestParam String dataSourceId, @RequestParam String tableName) {
        try {
            DataSourceUtil.switchDs(dataSourceId);
            final DruidDataSource dataSource = (DruidDataSource) DynamicDataSourceContextHolder.dataSourcesMap.get(dataSourceId);
            String sql = StrFormatter.format("SELECT UTC.COLUMN_NAME AS VALUE,UTC.DATA_TYPE AS TYPE,( SELECT  UCC.COMMENTS  FROM user_col_comments UCC WHERE UCC.COLUMN_NAME = UTC.COLUMN_NAME AND UCC.TABLE_NAME = UTC.TABLE_NAME ) AS LABEL FROM user_tab_columns UTC WHERE UTC.TABLE_NAME = '{}'", tableName);
            if (dataSource.getDriverClassName().toLowerCase().contains("mysql")) {
                sql = StrFormatter.format("SELECT column_name AS VALUE, DATA_TYPE AS TYPE, column_comment AS LABEL FROM information_schema.COLUMNS WHERE table_name = '{}'", tableName);
            }
            final List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
            return AjaxResult.success(maps);
        } finally {
            DataSourceUtil.switchDefaultDs();
        }
    }


    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }


    @IgnoreWebSecurity
    @GetMapping("/table/create")
    @ApiOperation("物理表生成")
    public AjaxResult createTable(@RequestParam String tableName,
                                  @RequestParam String templateId) {
        // 默认表名全大写
        tableName = tableName.toUpperCase();
        final DataTemplate template = dataTemplateService.getById(templateId);
        if (StringUtils.isBlank(template.getDataSourceId())) {
            return AjaxResult.error("请在模板编辑界面选择对应的数据源");
        }
        List<CreateFieldVO> fieldList = dataFieldService.getCreateFields(template.getId());
        if (CollectionUtils.isEmpty(fieldList)) {
            return AjaxResult.error("没有可生成表的字段配置,请新建字段");
        }
        // 判断是否有重复字段
        final List<String> collect = fieldList.stream()
                .collect(Collectors.groupingBy(CreateFieldVO::getFieldName, Collectors.counting()))
                .entrySet()
                .stream()
                .filter(entry -> entry.getValue() > 1)
                .map(Map.Entry::getKey)
                .collect(Collectors.toList());
        if (collect.size() > 0) {
            return AjaxResult.error(StrFormatter.format("字段信息中有重复字段名:[{}]", collect
                    .stream().map(item -> {
                        final Optional<CreateFieldVO> first = fieldList.stream().filter(i -> StringUtils.equals(i.getFieldName(), item)).findFirst();
                        return first.map(CreateFieldVO::getTitle).orElse(null);
                    }).filter(StringUtils::isNotBlank).collect(Collectors.joining(","))));
        }
        try {
            final DbType dbType = dataTemplateService.getDbType(template.getDataSourceId());
            DataSourceService.switchDb(template.getDataSourceId());
            if (dbType.equals(DbType.MYSQL)) {
                // mysql
                return AjaxResult.error("mysql数据因字段数量以及长度原因,暂不支持,请联系管理员");
                /*final Integer count = jdbcTemplate.queryForObject(StrFormatter.format("select count(table_name) from information_schema.TABLES where TABLE_NAME = '{}'", tableName), Integer.class);
                if (count > 0) {
                    return AjaxResult.error("此表已存在");
                }
                StringBuilder sb = new StringBuilder();
                sb.append("create table {} ( ");
                fieldList.forEach(field -> sb.append(field.getField())
                        .append(" varchar(32) null comment '")
                        .append(field.createComment()).append("',"));
                sb.append(" YEAR varchar(32) null").append(" ) comment '")
                        .append(template.createComment())
                        .append("';");
                // 同时创建数据表与临时表
                log.info("生成物理表的sql为:{}", sb);
                jdbcTemplate.execute(StrFormatter.format(sb.toString(), tableName));
                jdbcTemplate.execute(StrFormatter.format(sb.toString(), tableName + "_TEMP"));
                // 修改模板表绑定的表名
                final DataTemplate updateTemplate = new DataTemplate();
                updateTemplate.setId(template.getId());
                updateTemplate.setTableName(tableName);
                DataSourceUtil.switchDefaultDs();
                dataImportService.updateById(updateTemplate);*/
            } else {
                // oracle
                List<String> prodSqlList = new ArrayList<>();
                List<String> tempSqlList = new ArrayList<>();
                final String tempTableName = tableName + "_TEMP";
                String comment = "COMMENT ON COLUMN {}.{} IS '{}'";
                StringBuilder sql = new StringBuilder();
                sql.append("CREATE TABLE {} ( ");
                String finalTableName = tableName;
                fieldList.forEach(field -> {
                    sql.append(field.getFieldName()).append(" ").append(field.getFieldType()).append(" ,");
                    prodSqlList.add(StrFormatter.format(comment, finalTableName, field.getFieldName(), field.getTitle()));
                    tempSqlList.add(StrFormatter.format(comment, tempTableName, field.getFieldName(), field.getTitle()));
                });
                sql.append(String.join("", DiConstants.DEFAULT_FIELD_TEMPLATE));
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
                DiConstants.DEFAULT_FIELD_COMMENT_TEMPLATE.forEach(item -> {
                    prodSqlList.add(item.replaceAll("@tableName", finalTableName));
                    tempSqlList.add(item.replaceAll("@tableName", tempTableName));
                });
                prodSqlList.add(0, StrFormatter.format(sql.toString(), finalTableName));
                tempSqlList.add(0, StrFormatter.format(sql.toString(), tempTableName));
                prodSqlList.add(StrFormatter.format("COMMENT ON TABLE {} IS '{}'", finalTableName, template.createComment()));
                tempSqlList.add(StrFormatter.format("COMMENT ON TABLE {} IS '{}'", tempTableName, template.createComment()));
                // 同时创建数据表与临时表
                String[] prod = new String[prodSqlList.size()];
                String[] temp = new String[tempSqlList.size()];
                prodSqlList.toArray(prod);
                tempSqlList.toArray(temp);
                final Integer prodCount = jdbcTemplate.queryForObject(StrFormatter.format("select count(*) from user_tables where table_name =upper('{}')", tableName), Integer.class);
                if (prodCount == 0) {
                    jdbcTemplate.batchUpdate(prod);
                }
                final Integer tempCount = jdbcTemplate.queryForObject(StrFormatter.format("select count(*) from user_tables where table_name =upper('{}')", tempTableName), Integer.class);
                if (tempCount == 0) {
                    jdbcTemplate.batchUpdate(temp);
                }
                // 修改模板表绑定的表名
                final DataTemplate updateTemplate = new DataTemplate();
                updateTemplate.setId(template.getId());
                updateTemplate.setTableName(finalTableName);
                DataSourceService.switchDefault();
                dataTemplateService.updateById(updateTemplate);
            }
            return AjaxResult.success();
        } catch (Exception e) {
            log.error("物理表生成失败", e);
            return AjaxResult.error(e.getMessage());
        } finally {
            DataSourceService.switchDefault();
        }
    }

    @IgnoreWebSecurity
    @GetMapping("/analyze/export")
    @ApiOperation("数据分析并导出")
    public void analyzeExport(@RequestParam String templateId,
                              HttpServletResponse response) {
        ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                .eq(ExcelData::getTemplateId, templateId)
                .eq(ExcelData::getType, "1"), false);
        if (excelData == null) {
            try {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                response.getWriter().println(JSON.toJSONString(AjaxResult.error("请先导入数据文件")));
                response.getWriter().flush();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        excelDataService.analyzeExport(excelData, response);
    }

    @IgnoreWebSecurity
    @PostMapping("/clearTemp")
    @ApiOperation("清空临时表数据")
    public AjaxResult clearTemp(@RequestBody TemplateVO vo) {
        final DataTemplate template = dataTemplateService.getById(vo.getId());
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            String sql = StrFormatter.format("DELETE FROM {} WHERE YEAROOFDATARECORD = '{}'",
                    template.getTableName() + "_TEMP", template.getYear() + "年");
            //sql =  sql + " WHERE YEAR = '"+template.getYear()+"'";
            log.info("执行的sql为:[{}]", sql);
            jdbcTemplate.execute(sql);
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            DataSourceService.switchDefault();
        }
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PostMapping("/syncDb")
    @ApiOperation("一键导入正式库")
    public AjaxResult syncDb(@RequestBody TemplateVO vo) {
        final DataTemplate template = dataTemplateService.getById(vo.getId());
        if (template == null) {
            return AjaxResult.error("没有对应的模板");
        }
        final long count = excelDataService.count(Wrappers.lambdaQuery(ExcelData.class).eq(ExcelData::getTemplateId, template.getId())
                .eq(ExcelData::getType, "1"));
        if (count < 1) {
            return AjaxResult.error("请先上传导入数据");
        }
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            String insertSql = "INSERT INTO {} SELECT * FROM {} WHERE YEAROOFDATARECORD = '{}年'";
            String deleteSql = "DELETE FROM {} WHERE YEAROOFDATARECORD='{}年'";
            String updateEnterDate = "UPDATE {} SET ENTERDATA = SYSDATE WHERE YEAROOFDATARECORD='{}年'";
            jdbcTemplate.execute(StrFormatter.format(deleteSql, template.getTableName(), template.getYear()));
            jdbcTemplate.execute(StrFormatter.format(updateEnterDate, template.getTableName() + "_TEMP", template.getYear()));
            jdbcTemplate.execute(StrFormatter.format(insertSql,
                    template.getTableName(), template.getTableName() + "_TEMP", template.getYear()));
        } catch (Exception e) {
            throw new BaseException(e.getMessage());
        } finally {
            DataSourceService.switchDefault();
        }
        DataTemplate updateTemplate = new DataTemplate();
        updateTemplate.setId(template.getId());
        updateTemplate.setImportStatus("1");
        updateTemplate.setImportTime(new Date());
        dataTemplateService.updateById(updateTemplate);
        return AjaxResult.success();
    }


    public static void main(String[] args) {
        String field = "UNIFORM_CREDIT_NUMBER,ORG_CODE,ORG_NAME,DJZCLXDM,YLWSJGLBDM,JGFLGLDM,AREA_NUMBER_CODE,FORMSOF_INSTITU_OWNERSHIP,DWSSQX,DWSZXZJDMC,XZJDDM,SZZBDWDM,YLWSJGLSGXDM,DWSZDSFMZZZDF,SFFZJG,BASE_INFO,JGSZDZ,JGDLWZ,JD,WD,POST_CODE_UNIT,ORG_TEL,ORG_LEGALPERSON_NAME,SFDEMCWSQWSFWZXHXZWSY,SFWDXFSYY,SFYYJHJG,HOSPITAL_GRADE,HOSPITAL_LEVEL,SFKZHLWZLFW,SFHDHLWYYZYXK,NUMSUPPORT_MEDIINSTITU,NUMSUPPORTCLINICS,NUMSUPPORTPRIMARYINSTITU,NUM_CLIN_DEPT_HOSP,NUM_CLIN_DEPT_WITH_WARDS,NUM_CLIN_DEPT_WITH_TREATROOM,IS_FEVER_CLINIC,OP_TREAT_AREA_SIGNS,NUMOF_HOSP_SICK_AREA,NUMOF_SICK_AREA_WITHTREATROOM,KZYZHLFWDBQS,CHPROOM_SIGN,YYZYDYLJGZYZJPZS,TJZQTYLJGZYZJPZS,TJZBJGSYDYLJGZYZJPZS,PBDGJJBYWMLZZCYPZS,KZDMLNZYYLJSXMS,KZDMLWZYYLJSXMS,NUM_TCM_NURSING_PROJECTS,CDDTJYSKYKTS,NUM_SCIENRESEATOPIC_ABOVEPROV,CONSTRU_OF_INFOR_SYSTEM,USE_HIS,USE_LIS,USE_PACS,USE_CIS,USE_HRP,USE_OA,USE_HSB,IN_HOSP_MOBILE_HEALTHCARE,OUT_HOSP_MOBILE_HEALTHCARE,TELEMEDICINE_SYS,DZBLYYGNSPFJ,HLHTBZHCSD,YYZHGLFJ,NUM_PEOPLE_ONDUTY,TOTALNUMOFSENIOR_TITLES,TOTALNUMOFSUBSENIOR_TITLES,TOTALNUMOFMIDDLE_TITLES,TOTALNUMOFPRIMARY_TITLES,WSJSRYS,JYGJZCDJSRYS,TOTALNUMOFPRACTISDOC,NUMOF_TCMPRACTISDOC,NUMOFSENIORTCMPRACTISDOC,NUMOFSUBSENIORTCMPRACTISDOC,NUMOFMIDDLETCMPRACTISDOC,ZCWQKYXZYDRS,QDZYQKYSPXHGZDRS,ZYZCYSRS,NUMOF_NON_TCMPRACTISDOC,XYXXZYRYS,NUM_OF_PHARMACISTS,LCYSS,ZYSS,JYZGJZCRSZYSS,JYFGJZCRSZYSS,JYZJZCRSZYS,ZYSSS,TOTALNUM_OF_NURSES,NUMOF_NURSESSENIOR_TITLES,NUMOF_NURSESSUBSENIORTITLES,NUMOF_NURSESMIDTITLES,NUMOF_NURSES_TRAINED,CJJXJYBQDGDXFDZYYZYJSRYS,TOTALNUM_OFHOSPLEADERS,NUM_OFHOSPLEADEWITHTCMPROFESS,NUM_OFHOSPLEADEWITHTCMPRACT,FZYLBZYZLYSDJYZYYZYXLHXWDRS,NUM_OFHOSPLEADEWITHTCMTRAIN,CLINICALDEPT,NUMTCM_PRACTDOCINCLINDEPT,NUMTCM_TRAINDOCINCLINDEPT,NUMOFPEOPLEIN_TDD,NUMTCM_DOC_NUR_INTDD,NUMOFTCMWITH_STANDARDTRAIN,NUMOFBEDPREPARED,TOTAL_NNUM_BEDS,NUMOFBEDINICU,FYBFCWS,NUMOFSPECIALBED,YLCWS,NUMOFDAYSOPENED,NUMOFDAYSOCCUPIED,NUMOFDAYSOCCUPIEDOUTHISP,TOTAL_AREAOFHOUSING,BUSINESS_ROOM_SIZE,CHPROOM_AREA,NUMOFEQUIPOVERFIVETHOUSRMB,NUMTCMEQUIPOVERFIVETHOUSRMB,ALLVALUEOFEQUIPOVERMILION,ALLVALUE_TCMEQUIPOVERMILION,ANNUAL_GROSS_INCOME,INCOMEFROM_FINANCIAL_ASSIS,MEDICAL_INCOME,TCYGXHDYLSR,HCZSR,ZDJKGZYYHCSR,OUTPATIENT_INCOME,INCOMEFROM_OP_TCMSERVICES,TXYLSRMZ,OUTPATIENT_DRUG_INCOME,OUTPATIENT_WM_INCOME,ZDJKHXYPHSWZPSRMZ,OUTPATIENT_CPM_INCOME,YLJGZYZJSRMZ,OUTPATIENT_CHM_INCOME,INPATIENT_INCOME,INCOMEFROM_IP_TCMSERVICES,TXYLSRZY,INPATIENT_DRUG_INCOME,INPATIENT_WM_INCOME,ZDJKHXYPHSWZPSRZY,INPATIENT_CPM_INCOME,YLJGZYZJSRZY,INPATIENT_CHM_INCOME,SETTLEMENT_BALANCE,KYXMLXJFZJF,CDDTJYSHDTJKYKTJF,RESEARCH_TOPICS_FEE,ZYYKYXMLXJFZJF,YYDNZJF,NZNH,YXYXJXJFTR,BYHYXJYJFTR,JXYXJYJFTR,TOTAL_FREQOF_DIAG_AND_TREAT,MJZRCS,NUM_OF_OP,YYZYYPZLRCS,FREQOF_NON_DRUG_DIAG_IN_CM,NUM_ACUPUNC_OPND,NUM_MASSAGE_OPND,NUM_MINIMAL_INVASIVE_OPND,NUM_MANUAL_RESET_OPND,NUM_WITHOTHERSDIG_OPND,NUMSPECIALIST_CLINIC,NUM_TCM_SPECIALIST_CLINIC,NUM_WITHSPECIAL_NEEDSOP,NUM_BOOKING_CLINIC,HLWZLFWRCS,FEVER_CLINIC_FREQUENCY,YYDDLJSJ,NUM_TCM_NONDRUG_TREATOP,NUM_ACUPUNC_OPNT,NUM_MASSAGE_OPNT,NUM_MINIMAL_INVASIVE_OPNT,NUM_MANUAL_RESET_OPNT,NUM_WITHOTHERSDIG_OPNT,CYRS,NUM_OUTHIS_TREATED_BY_CHP,NUM_OUTHIS_USETCM_TECH,NUM_OUTHIS_USETCM_EQUIP,NUM_OUTHIS_USECHP,YZYWZZLDCYRS,NUM_OUTHISWITHSPECIAL_NEEDS,NUM_DISCHARGED_OF_DIFF_DISEA,NUM_EMERGENCY_DISCHARGE,XYWCYRS,TOTALNUMDEATHSIN_HOSPITAL,NUM_SURGICAL_TREAT_INHIS,NUM_TCM_SURGICAL_TREAT_INHIS,NUMOFSURGIINLEVELTHREE_FOUR,NUMTCMSURGIINLEVELTHREE_FOUR,ILQLSSZLRS,ZQSSZLRS,RJSHZLRS,ZYCYRJSSZLRS,NUMPATIINICU,NUM_TCM_TREATINICU,NUM_TCM_NURSING_INWARDS,NUMRESCUED,NUMSUCCESSRESCUED,ZZDSJYYDRCS,ZZDBYDRCS,ZZDXJYYHJCYLWSJGRCS,NUMOF_OUTPATIENT_PRESCRIP,NUMOF_PRESCRIPTIONS_IN_CM,NUMOFPRES_FOR_BULK_CHDT,NUMOFPRES_FORSMALLPAC_CHDT,NUMPRESOFCHFG,NUMOF_PCM_PRESCRIPTION,YLJGZYZJCFS,JZYWCFS,TOTAL_NUMOFCHDT,NUMOFDEPT_IMPLE_CP,NUMOFDEPT_IMPLE_TCMCP,NUMOFDISEA_IMPLE_CP,NUMOFDISEA_IMPLE_TCMCP,TOTALNUMOP_ROUTECASES,TOTALNUMOP_TCMROUTECASES,NUMOP_EXE_PATH_CASES,NUMOP_EXE_TCMPATH_CASES,NUMOP_FINI_PATH_CASES,NUMOP_FINI_TCMPATH_CASES,TOTALNUMIP_ROUTECASES,TOTALNUMIP_TCMROUTECASES,NUMIP_EXE_PATH_CASES,NUMIP_EXE_TCMPATH_CASES,NUMIP_FINI_PATH_CASES,NUMIP_FINI_TCMPATH_CASES,YYGRZRS,ILQKSSBWGRRS,ZQSSHZBFZLS,DXYYSBJCRCS,DXYYSBJCYXS,CFZS,DPCFS,ZYCFS,DPZYCFS,CYHZZYYZDPS,ZYZYYZDPS,ZYHZKJYWXHL,MZSYYWDZLRCS,MZSYJBYWDZLRCS,ZYQJSYYWDCYRS,ZYQJSYJBYWRS,YYCGYWPZZS,YYCGJBYWPZS,GJZZYPJZCGZBYPTPZYPYL,GJZZYPJZCGZBYPYL,YYZSJXZRS,YYJSDKZYYYJXRS,YYJSYLTNYYRYJXRS,YYJSQTYYRYJXRS,LCDJJSHZDYSRS,LCDJJSHZDLSJSSJYSPXQQDPXHGZSRS,YYJYPXXYS,YXJYZZGLRYS,GJSCJYZDLSRS,SJJYSSCJYZDLSRS,DSJJYXSCJYZDLSRS,YJSCJYZDLSRS,CJSJJYSSCJYRS,FBDJXLWS,ZDXKZDZKTRJFZJE,ZYYKYCGZHZJE,SFSZNK,SFSZFBK,NUMOFBEDS_LDD,NUMOP_EMERG_LDD,NUMDISCHARGED_LDD,SFSZPWBK,NUMOFBEDS_SASDEPT,NUMOP_EMERG_SASDEPT,NUMDISCHARGED_SASDEPT,SFSZNBK,NUMOFBEDS_BDDIVI,NUMOP_EMERG_BDDIVI,NUMDISCHARGED_BDDIVI,SFSZXXGK,NUMOFBEDS_CARDIOVDEPT,NUMOP_EMERG_CARDIOVDEPT,NUMDISCHARGED_CARDIOVDEPT,SFSZXYK,NUMOFBEDS_HEMATODEPT,NUMOP_EMERG_HEMATODEPT,NUMDISCHARGED_HEMATODEPT,SFSZSBK,NUMOFBEDS_NEPHRODEPT,NUMOP_EMERG_NEPHRODEPT,NUMDISCHARGED_NEPHRODEPT,SFSZNFMK,NUMOFBEDS_ENDOCRDIVI,NUMOP_EMERG_ENDOCRDIVI,NUMDISCHARGED_ENDOCRDIVI,SFSZFSBK,NUMOFBEDS_RHEUMADEPT,NUMOP_EMERG_RHEUMADEPT,NUMDISCHARGED_RHEUMADEPT,SFSZGBK,NUMOFBEDS_HEPATODEPT,NUMOP_EMERG_HEPATODEPT,NUMDISCHARGED_HEPATODEPT,SFSZGRXJBK,NUMOFBEDS_INFECTDIVI,NUMOP_EMERG_INFECTDIVI,NUMDISCHARGED_INFECTDIVI,SFSZSZBK,NUMOFBEDS_PSYCHIDEPT,NUMOP_EMERG_PSYCHIDEPT,NUMDISCHARGED_PSYCHIDEPT,SFSZWK,SFSZFCK,SFSZCK,SFSZEK,SFSZXSEK,SFSZPFK,SFSZYK,SFSZEBYHK,SFSZKQK,SFSZZLK,SFSZGSK,SFSZGCK,SFSZLNBK,SFSZZJK,SFSZTNK,SFSZKFYXK,SFSZJZK,TREATDISEA_WITHOUTDISEA_SIGNS,NUMOFBEDS_TREATDEPTOFDISEA,NUMOP_EMERG_TREATDEPTOFDISEA,NUMDISCHARGED_TREATDEPTOFDISEA,SFSZZZYXK,NUMOFBEDS_ICU,NUMOP_EMERG_ICU,NUMDISCHARGED_ICU,SFSZYFBJK,SFSZQTZYK,SFSZWWEYXK,SFSZZYXK,SFSZMYXK,SFSZYYXK,SFSZDYXK,SFSZQTMZY,SFSZZXYJHK,SFSZQTKS,NUMOFBEDS_OTHERDEPT,NUMOP_EMERG_OTHERDEPT,NUMDISCHARGED_OTHERDEPT,DWFZR,TJFZR,NAME_OF_APPLICANT,LXDH,DORDER,YEAROOFDATARECORD,ROWCODE";
        String value = "'91420984MA48RW8W9D','91420984-D','汉川同和中医医院','私营企业','中医(综合)医院','营利性医疗机构','420984','民营','汉川市','仙女山街道办事处霍城大道8号','000','卫生健康行政部门','县(旗)属','否','否','','汉川市霍城大道8号','','113.824623','30.663813','432300','18672299136','刘方钰','否','否','否','未定级','未定等','否','否','0','0','0','2','0','2','否','否','2','1','2','是','0','0','0','0','0','0','0','0','0','','有','无','无','无','无','无','无','无','无','无','未测评','未测评','未测评','71','0','2','19','14','40','0','14','14','0','1','9','0','0','1','0','0','7','0','1','0','0','0','5','16','0','1','10','14','0','5','2','1','0','0','8','4','0','6','4','0','60','60','0','0','0','0','21900','21000','10624','3300','2800','56','70','33','173','25','10505','0','9825','159','159','0','5825','3403','0','2726','49','0','67','0','2610','4000','3006','0','724','390','0','4','0','330','0','0','0','0','0','0','0','0','0','0','20000','18000','18000','8000','16064','3800','1672','10530','82','0','10886','10886','0','0','0','0','0','230546','110834','3800','10530','105300','82','996','577','268','624','0','996','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','1100','600','1000','996','900','0','0','996','996','996','0','3','3','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','0','设置','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','未设置','-','-','-','设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','设置','未设置','未设置','未设置','设置','设置','未设置','设置','60','10','10','未设置','-','-','-','未设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','未设置','-','-','-','刘方钰','陈骁','陈骁','13469976551','1692071286103384','2023年','1692071286103385'";
        String[] fields = field.split(",");
        String[] values = value.split(",");
        for (int i = 0; i < fields.length; i++) {
            System.out.println(StringUtils.format("UPDATE T0801_TCMHOSP_TEMP SET {} = {} WHERE ROWCODE = '123';",fields[i].replaceAll("\n",""),values[i]));
        }
    }



}
