package com.tbyf.his.web.controller.dataImport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.web.dataImport.domain.param.AddDictParam;
import com.tbyf.his.web.dataImport.domain.param.QueryAreaParam;
import com.tbyf.his.web.dataImport.domain.param.UpdateDictParam;
import com.tbyf.his.web.dataImport.entity.DataDict;
import com.tbyf.his.web.dataImport.service.DataDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/16 15:30
 */
@RestController
@Api(tags = "字典接口")
@RequestMapping("/data/dict")
@Slf4j
public class DictDataController {

    @Autowired
    private DataDictService dictService;

    @IgnoreWebSecurity
    @GetMapping("")
    @ApiOperation("字典查询")
    public AjaxResult queryDict(@RequestParam String type) {
        final LambdaQueryWrapper<DataDict> wrapper = Wrappers.lambdaQuery(DataDict.class)
                .eq(DataDict::getType, type);
        final List<Map<String, String>> list = dictService.list(wrapper).stream().map(item -> {
            String json = item.getRemarks();
            item.setRemarks(null);
            final Map<String, String> map = BeanUtils.getFieldValueMap(item);
            if (StringUtils.isNotBlank(json)) {
                try {
                    final JSONObject object = JSON.parseObject(json);
                    object.forEach((key, value) -> {
                        map.put(key, (String) value);
                    });
                } catch (Exception ignore) {
                }
            }
            return map;
        }).collect(Collectors.toList());
        return AjaxResult.success(list);
    }

    @IgnoreWebSecurity
    @GetMapping("/area")
    @ApiOperation("机构查询")
    public TableDataInfo searchArea(QueryAreaParam param) {
        final LambdaQueryWrapper<DataDict> wrapper = Wrappers.lambdaQuery(DataDict.class);
        wrapper.eq(DataDict::getType, "area")
                .like(StringUtils.isNotBlank(param.getValue()), DataDict::getValue, param.getValue())
                .like(StringUtils.isNotBlank(param.getLabel()), DataDict::getLabel, param.getLabel())
                .orderByAsc(DataDict::getValue);
        Page<DataDict> page = Page.of(param.getPageNum(), param.getPageSize());
        page = dictService.page(page, wrapper);
        return param.convert(page);
    }

    @IgnoreWebSecurity
    @PostMapping("")
    @ApiOperation("新增字典")
    public AjaxResult addDict(@RequestBody AddDictParam param) {
        // 查询是否有重复
        final LambdaQueryWrapper<DataDict> wrapper = Wrappers.lambdaQuery(DataDict.class)
                .eq(DataDict::getType, param.getType())
                .eq(DataDict::getValue, param.getValue());
        final long count = dictService.count(wrapper);
        if (count > 0) {
            return AjaxResult.error("新增相同的字典值");
        }
        DataDict dict = new DataDict();
        BeanUtils.copyProperties(param, dict);
        dictService.save(dict);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PostMapping("/update")
    @ApiOperation("修改字典")
    public AjaxResult updateDict(@RequestBody @Validated UpdateDictParam param) {
        DataDict template = new DataDict();
        BeanUtils.copyProperties(param, template);
        dictService.updateById(template);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/delete")
    @ApiOperation("删除字典")
    public AjaxResult deleteDict(@RequestParam String dictId) {
        dictService.removeById(dictId);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/importArea")
    @ApiOperation("导入行政区划信息")
    public AjaxResult importArea() {
        List<DataDict> dictList = new ArrayList<>();
        Map<String, String> map = new HashMap<>();
        map.put("420000", "湖北省");
        map.put("420100", "武汉市");
        map.put("420102", "江岸区");
        map.put("420103", "江汉区");
        map.put("420104", "硚口区");
        map.put("420105", "汉阳区");
        map.put("420106", "武昌区");
        map.put("420107", "青山区");
        map.put("420117", "新洲区");
        map.put("420112", "东西湖区");
        map.put("420113", "汉南区");
        map.put("420114", "蔡甸区");
        map.put("420115", "江夏区");
        map.put("420116", "黄陂区");
        map.put("420111", "洪山区");
        //map.put("420111"," 洪山区(东湖风景区)");
        //map.put("420111","洪山区(东湖高新区)");
        map.put("420200", "黄石市");
        map.put("420202", "黄石港区");
        map.put("420203", "西塞山区");
        map.put("420204", "下陆区");
        map.put("420205", "铁山区");
        map.put("420222", "阳新县");
        map.put("420281", "大冶市");
        map.put("420300", "十堰市");
        map.put("420303", "张湾区");
        map.put("420322", "郧西县");
        map.put("420323", "竹山县");
        map.put("420324", "竹溪县");
        map.put("420325", "房县");
        map.put("420304", "郧阳区");
        map.put("420302", "茅箭区");
        //map.put("420302","茅箭区(开发区)");
        map.put("420381", "丹江口市");
        //map.put("420381"," 丹江口市(武当山特区)");
        map.put("420500", "宜昌市");
        map.put("420502", "西陵区");
        map.put("420503", "伍家岗区");
        map.put("420504", "点军区");
        map.put("420505", "猇亭区");
        map.put("420506", "夷陵区");
        map.put("420525", "远安县");
        map.put("420526", "兴山县");
        map.put("420527", "秭归县");
        map.put("420581", "宜都市");
        map.put("420528", "长阳土家族自治县");
        map.put("420529", "五峰土家族自治县");
        map.put("420582", "当阳市");
        map.put("420583", "枝江市");
        map.put("420600", "襄阳市");
        map.put("420602", "襄城区");
        map.put("420606", "樊城区");
        //map.put("420606","樊城区（高新区）");
        map.put("420607", "襄州区");
        map.put("420624", "南漳县");
        map.put("420625", "谷城县");
        map.put("420626", "保康县");
        map.put("420682", "老河口市");
        map.put("420683", "枣阳市");
        map.put("420684", "宜城市");
        map.put("420700", "鄂州市");
        map.put("420702", "梁子湖区");
        map.put("420703", "华容区");
        map.put("420704", "鄂城区");
        //map.put("420704","鄂城区（社管办）");
        map.put("420800", "荆门市");
        map.put("420802", "东宝区");
        map.put("420804", "掇刀区");
        map.put("420822", "沙洋县");
        map.put("420881", "钟祥市");
        map.put("420882", "京山市");
        map.put("420900", "孝感市");
        map.put("420902", "孝南区");
        map.put("420921", "孝昌县");
        map.put("420922", "大悟县");
        map.put("420923", "云梦县");
        map.put("420981", "应城市");
        map.put("420982", "安陆市");
        map.put("420984", "汉川市");
        map.put("421000", "荆州市");
        map.put("421002", "沙市区");
        //map.put("421002","沙市区（开发区）");
        map.put("421003", "荆州区");
        map.put("421022", "公安县");
        map.put("421024", "江陵县");
        //map.put("421024","江陵县（开发区）");
        map.put("421081", "石首市");
        map.put("421083", "洪湖市");
        map.put("421087", "松滋市");
        map.put("421088", "监利市");
        map.put("421100", "黄冈市");
        map.put("421102", "黄州区");
        map.put("421121", "团风县");
        map.put("421122", "红安县");
        map.put("421123", "罗田县");
        map.put("421124", "英山县");
        map.put("421125", "浠水县");
        map.put("421126", "蕲春县");
        map.put("421127", "黄梅县");
        map.put("421181", "麻城市");
        map.put("421182", "武穴市");
        map.put("421200", "咸宁市");
        map.put("421202", "咸安区");
        map.put("421221", "嘉鱼县");
        map.put("421222", "通城县");
        map.put("421223", "崇阳县");
        map.put("421224", "通山县");
        map.put("421281", "赤壁市");
        map.put("421300", "随州市");
        map.put("421303", "曾都区");
        map.put("421321", "随县");
        map.put("421381", "广水市");
        map.put("422800", "恩施土家族苗族自治州");
        map.put("422801", "恩施市");
        map.put("422802", "利川市");
        map.put("422822", "建始县");
        map.put("422823", "巴东县");
        map.put("422825", "宣恩县");
        map.put("422826", "咸丰县");
        map.put("422827", "来凤县");
        map.put("422828", "鹤峰县");
        map.put("429004", "仙桃市");
        map.put("429005", "潜江市");
        map.put("429006", "天门市");
        map.put("429021", "神农架林区");
        map.forEach((key, value) -> {
            DataDict dict = new DataDict();
            dict.setType("area").setValue(key).setLabel(value);
            dictList.add(dict);
        });
        dictService.remove(Wrappers.lambdaQuery(DataDict.class).eq(DataDict::getType, "area"));
        dictService.saveBatch(dictList);
        return AjaxResult.success();
    }

}
