package com.tbyf.his.web.controller.system;

import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.system.domain.SysCategory;
import com.tbyf.his.system.service.ISysCategoryService;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.Iterator;
import java.util.List;

/**
 * 插件种类信息
 */
@RestController
@RequestMapping("/system/category")
public class SysCategoryController extends BaseController {
    @Autowired
    private ISysCategoryService categoryService;

    /**
     * 获取插件种类列表
     */
    @PreAuthorize("@ss.hasPermi('system:category:list')")
    @GetMapping("/list")
    public AjaxResult list(SysCategory category) {
        List<SysCategory> categories = categoryService.selectDeptList(category);
        return AjaxResult.success(categories);
    }

    /**
     * 获取插件种类列表（排除节点）
     */
    @PreAuthorize("@ss.hasPermi('system:category:list')")
    @GetMapping("/list/exclude/{categoryId}")
    public AjaxResult excludeChild(@PathVariable(value = "categoryId", required = false) Long categoryId) {
        List<SysCategory> categories = categoryService.selectDeptList(new SysCategory());
        Iterator<SysCategory> it = categories.iterator();
        while (it.hasNext()) {
            SysCategory c = (SysCategory) it.next();
            if (c.getCategoryId().intValue() == categoryId
                    || ArrayUtils.contains(StringUtils.split(c.getAncestors(), ","), categoryId + "")) {
                it.remove();
            }
        }
        return AjaxResult.success(categories);
    }

    /**
     * 根据部门编号获取详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:category:query')")
    @GetMapping(value = "/{categoryId}")
    public AjaxResult getInfo(@PathVariable Long categoryId) {
        categoryService.checkCategoryDataScope(categoryId);
        return AjaxResult.success(categoryService.selectCategoryById(categoryId));
    }

    /**
     * 获取部门下拉树列表
     */
    @GetMapping("/treeselect")
    public AjaxResult treeselect(SysCategory category) {
        List<SysCategory> categories = categoryService.selectDeptList(category);
        return AjaxResult.success(categoryService.buildCategoryTreeSelect(categories));
    }

}
