package com.tbyf.his.web.controller.system;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.tbyf.his.framework.system.domain.SysReportFile;
import com.tbyf.his.framework.system.service.ISysReportFileService;

/**
 * 报表管理Controller
 *
 * @author guopx
 * @date 2022-03-04
 */
@RestController
@RequestMapping("/system/report/file")
public class SysReportFileController extends BaseController {
    @Autowired
    private ISysReportFileService sysReportFileService;

    /**
     * 查询报表管理列表
     */
    @PreAuthorize("@ss.hasPermi('report:file:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysReportFile sysReportFile) {
        startPage();
        List<SysReportFile> list = sysReportFileService.selectSysReportFileList(sysReportFile);
        return getDataTable(list);
    }

    /**
     * 导出报表管理列表
     */
    @PreAuthorize("@ss.hasPermi('report:file:export')")
    @Log(title = "报表管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysReportFile sysReportFile) {
        List<SysReportFile> list = sysReportFileService.selectSysReportFileList(sysReportFile);
        ExcelUtil<SysReportFile> util = new ExcelUtil<SysReportFile>(SysReportFile.class);
        util.exportExcel(response, list, "报表管理数据");
    }

    /**
     * 获取报表管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('report:file:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(sysReportFileService.selectSysReportFileById(id));
    }

    /**
     * 新增报表管理
     */
    @PreAuthorize("@ss.hasPermi('report:file:add')")
    @Log(title = "报表管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysReportFile sysReportFile) {
        return toAjax(sysReportFileService.insertSysReportFile(sysReportFile));
    }

    /**
     * 修改报表管理
     */
    @PreAuthorize("@ss.hasPermi('report:file:edit')")
    @Log(title = "报表管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysReportFile sysReportFile) {
        return toAjax(sysReportFileService.updateSysReportFile(sysReportFile));
    }

    /**
     * 删除报表管理
     */
    @PreAuthorize("@ss.hasPermi('report:file:remove')")
    @Log(title = "报表管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(sysReportFileService.deleteSysReportFileByIds(ids));
    }
}
