package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * 非空规则校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_NOTNULL)
@Slf4j
public class NotNullValidator implements RuleValidator {

    @Override
    public void validate(RuleVO rule) {
        try {
            if (StringUtils.isBlank(rule.getValue())) {
                rule.setResult(StringUtils.format("非空校验 {} 未通过", rule.getName()));
                return;
            }
            if (StringUtils.isNotBlank(rule.getContent())) {
                final String[] badArray = rule.getContent().split(DiConstants.SEPARATOR);
                for (String badStr : badArray) {
                    if (StringUtils.equals(badStr, rule.getValue())) {
                        rule.setResult(StringUtils.format("非空校验 {} 未通过", rule.getName()));
                        return;
                    }
                }
            }
        } catch (Exception e) {
            log.error("非空校验未通过", e);
            rule.setResult(StringUtils.format("非空校验 {} 未通过", rule.getName()));
        }
    }
}
