package com.tbyf.his.web.dataImport.domain.param;

import com.tbyf.his.web.dataImport.domain.BaseMp;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel(value = "更新模板", description = "更新模板")
public class UpdateTemplateParam extends BaseMp implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "模板ID")
    @NotBlank(message = "模板ID不能为空")
    private String id;

    @ApiModelProperty(value = "模板名称")
    private String name;

    @ApiModelProperty(value = "机构类型")
    private String orgName;

    @ApiModelProperty(value = "导入状态 1-已导入 0-未导入")
    private String importStatus;

    @ApiModelProperty(value = "数据年份")
    private String year;

    @ApiModelProperty(value = "数据源ID")
    private String dataSourceId;

    @ApiModelProperty(value = "表名")
    private String tableName;

}
