package com.tbyf.his.web.dataImport.domain.vo;

import com.tbyf.his.common.annotation.Excel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * excel模型
 *
 * @author lzz
 * @date 2023/2/12 21:20
 */

@Data
@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
public class ExcelVO {

    @Excel(name = "机构类型")
    private String orgType;

    @Excel(name = "医疗机构名称", width = 30)
    private String orgName;

    @Excel(name = "医疗机构代码")
    private String orgCode;

    @Excel(name = "统一社会信用代码")
    private String unifiedCode;

    @Excel(name = "数据代码")
    private String code;

    @Excel(name = "指标名称", width = 24)
    private String title;

    @Excel(name = "信息/数值")
    private String value;

    @Excel(name = "错误原因", width = 30)
    private String message;

    @Excel(isExport=false)
    private String areaCode;

    public ExcelVO(String message, String value) {
        this.message = message;
        this.value = value;
    }

}
