package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "data_field", autoResultMap = true)
@ApiModel(value = "数据字段表", description = "数据字段表")
public class DataField implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "模板ID")
    @TableField("template_id")
    private String templateId;

    @ApiModelProperty(value = "代码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @TableField("title")
    private String title;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标,例如 C,4")
    @TableField("coordinate")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "数据库字段名")
    @TableField("field")
    private String field;

    transient private float ratio;

    public float getSimilarityRatio(DataField dataField) {
        float result = 0;
        if (StringUtils.isNotBlank(this.getCode()) && StringUtils.isNotBlank(dataField.getCode())) {
            result += DataImportUtils.getSimilarityRatio(this.getCode(), dataField.getCode());
        } else if (StringUtils.equals(this.getCode(), dataField.getCode())) {
            result += 1;
        }
        if (StringUtils.isNotBlank(this.getTitle()) && StringUtils.isNotBlank(dataField.getTitle())) {
            result += DataImportUtils.getSimilarityRatio(this.getTitle(), dataField.getTitle());
        } else if (StringUtils.equals(this.getTitle(), dataField.getTitle())) {
            result += 1;
        }
        if (StringUtils.isNotBlank(this.getUnit()) && StringUtils.isNotBlank(dataField.getUnit())) {
            result += DataImportUtils.getSimilarityRatio(this.getUnit(), dataField.getUnit());
        } else if (StringUtils.equals(this.getUnit(), dataField.getUnit())) {
            result += 1;
        }
        return result;
    }

    public String createComment() {
        return Stream.of(code, title)
                .filter(StringUtils::isNotBlank)
                .collect(Collectors.joining(" - "));
    }

}
