package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "data_rule", autoResultMap = true)
@ApiModel(value = "数据规则表", description = "数据规则表")
public class DataRule implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "规则名称")
    @TableField("name")
    private String name;

    @ApiModelProperty(value = "规则类型 1-基础规则 2-组合规则 3-模板规则")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "规则验证模式")
    @TableField("mode")
    private String mode;

    @ApiModelProperty(value = "规则验证内容")
    @TableField("content")
    private String content;

    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks;

}
