package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "excel_data", autoResultMap = true)
@ApiModel(value = "excel存储表", description = "excel存储表")
public class ExcelData implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "文件名")
    @TableField("file_name")
    private String fileName;

    @ApiModelProperty(value = "文件数据")
    @TableField("file")
    private byte[] file;

    @ApiModelProperty(value = "文件类型 1-初始导入文件 2-标准模板文件")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "模板ID")
    @TableField("template_id")
    private String templateId;

    @ApiModelProperty(value = "数据年份")
    @TableField("year")
    private String year;

    @ApiModelProperty(value = "机构类型")
    @TableField("org_name")
    private String orgName;

}
