package com.tbyf.his.web.dataImport.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.web.dataImport.domain.param.QueryTemplateParam;
import com.tbyf.his.web.dataImport.domain.vo.FieldErrorVo;
import com.tbyf.his.web.dataImport.domain.vo.TemplateVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataRule;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.mapper.DataTemplateMapper;
import com.tbyf.his.web.dataImport.mapper.MetaFieldMapper;
import com.tbyf.his.web.dataImport.service.DataTemplateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class DataTemplateServiceImpl extends ServiceImpl<DataTemplateMapper, DataTemplate> implements DataTemplateService {

    @Autowired
    private DataTemplateMapper dataTemplateMapper;

    @Autowired
    private MetaFieldMapper metaFieldMapper;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    private static final String alterSql = "ALTER TABLE {} MODIFY ( {} {} )";

    @Override
    public List<TemplateVO> queryTemplate(QueryTemplateParam param) {
        return dataTemplateMapper.queryTemplate(param);
    }

    @Override
    public DbType getDbType(String dataSourceId) {
        final String dbType = dataTemplateMapper.queryDbType(dataSourceId);
        if (StringUtils.isBlank(dbType)) {
            return DbType.MYSQL;
        }
        if (dbType.toUpperCase().contains("MYSQL")) {
            return DbType.MYSQL;
        } else {
            return DbType.ORACLE;
        }
    }

    @Override
    public List<VerifyVO> getVerify(String id) {
        return dataTemplateMapper.getVerify(id);
    }

    @Override
    public List<DataRule> getAllRule(String templateId) {
        return dataTemplateMapper.getAllRule(templateId);
    }

    @Async
    public CompletableFuture<List<FieldErrorVo>> getTableFieldError(List<FieldErrorVo> fieldErrorVos, String tableName) {
        log.info("start");
        List<FieldErrorVo> resultList = new ArrayList<>();
        try {
            DataSourceUtil.switchDs(DataSourceType.SLAVE.name());
            if (metaFieldMapper.selectTableCount(tableName) > 0) {
                fieldErrorVos.forEach(item -> {
                    if (StrUtil.isAllNotBlank(item.getFieldType(),item.getFieldName())){
                        String fieldType = item.getFieldType();
                        String columnType;
                        if (fieldType.contains("NUMBER")) {
                            columnType = metaFieldMapper.selectNumberFieldType(tableName, item.getFieldName());
                        } else {
                            columnType = metaFieldMapper.selectFieldType(tableName, item.getFieldName());
                        }
                        //元字段存在、物理表字段可能不存在
                        if (StringUtils.isNotBlank(columnType) && !StringUtils.equals(fieldType, columnType) && !isVarcharLengthEqual(fieldType, columnType)) {
                            FieldErrorVo fieldErrorVo = new FieldErrorVo();
                            BeanUtils.copyBeanProp(fieldErrorVo, item);
                            resultList.add(fieldErrorVo.setColumnType(columnType).setTableName(tableName));
                        }
                    }
                });
            }
        } finally {
            DataSourceUtil.switchDefaultDs();
        }
        return CompletableFuture.completedFuture(resultList);
    }

    public void syncFieldError(String fieldType, String fieldName, String tableName) {
        try {
            DataSourceUtil.switchDs(DataSourceType.SLAVE.name());
            String sql = StrFormatter.format(alterSql, tableName, fieldName, fieldType);
            jdbcTemplate.execute(sql);
        } catch (Exception e) {
            log.error("修改数据类型失败",e);
        }finally {
            DataSourceUtil.switchDefaultDs();
        }
    }

    protected boolean isVarcharLengthEqual(String fieldType, String columnType) {
        return fieldType.contains("VARCHAR") && columnType.contains("VARCHAR") &&
                fieldType.substring(fieldType.indexOf("(") + 1, fieldType.indexOf(")")).equals(columnType.substring(columnType.indexOf("(") + 1, columnType.indexOf(")")));
    }
}
