package com.tbyf.his.adapter.service.impl;

import com.tbyf.his.adapter.domain.AdapterPublishColumn;
import com.tbyf.his.adapter.domain.QueryAdapterColumVo;
import com.tbyf.his.adapter.mapper.AdapterPublishColumnMapper;
import com.tbyf.his.adapter.service.AdapterPublishColumnService;
import com.tbyf.his.adapter.util.AdapterConstant;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Author:lph
 * Date:2022/11/16 15:48
 **/
@DataSource(value = DataSourceType.SLAVE)
@Service
public class AdapterPublishColumnServiceImpl implements AdapterPublishColumnService {

    @Autowired
    AdapterPublishColumnMapper adapterPublishColumnMapper;

    @Override
    public int insertAdapterColumn(AdapterPublishColumn adapterPublishColumn) {
        adapterPublishColumnVerify(adapterPublishColumn);
        return adapterPublishColumnMapper.insertSelective(adapterPublishColumn);
    }

    @Override
    public List<AdapterPublishColumn> selectBySourceTableName(QueryAdapterColumVo columVo) {
        return adapterPublishColumnMapper.selectBySourceName(columVo);
    }

    @Override
    public AdapterPublishColumn selectColumnById(Long id) {
        return adapterPublishColumnMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateAdapterColumn(AdapterPublishColumn adapterPublishColumn) {
        adapterPublishColumnVerify(adapterPublishColumn);
        return adapterPublishColumnMapper.updateByPrimaryKeySelective(adapterPublishColumn);
    }

    @Override
    public void deleteAdapterPublishColumnByIds(List<Long> ids) {
        for (Long id : ids) {
            adapterPublishColumnMapper.deleteByPrimaryKey(id);
        }
    }

    /**
     * 发布列转换模式相关字段校验
     */
    private void adapterPublishColumnVerify(AdapterPublishColumn adapterPublishColumn) {
        switch (adapterPublishColumn.getConvertMode()) {
            case AdapterConstant.COMMON_COLUMN:
            case AdapterConstant.RANGE_CONVERT:
                break;
            case AdapterConstant.FORMULA_CONVERT:
            case AdapterConstant.SQL_CONVERT:
            case AdapterConstant.CONSTANT_CONVERT:
                if (StringUtils.isEmpty(adapterPublishColumn.getColumnConvertValue())) {
                    throw new ServiceException("列转换值不能为空");
                }
                break;
            case AdapterConstant.BASE_DATA:
                if (StringUtils.isEmpty(adapterPublishColumn.getRelationQueryTable())) {
                    throw new ServiceException("关联查询表不能为空");
                }
                if (StringUtils.isEmpty(adapterPublishColumn.getRelationResultColumn())) {
                    throw new ServiceException("关联结果列不能为空");
                }
                if (StringUtils.isEmpty(adapterPublishColumn.getRelationQueryColumn())) {
                    throw new ServiceException("关联查询列不能为空");
                }
                if (StringUtils.isEmpty(adapterPublishColumn.getSourceRelationColumn())) {
                    throw new ServiceException("源表关联列不能为空");
                }
                break;
            default:
                throw new ServiceException("发布列转换类型异常");
        }
    }
}
