package com.tbyf.his.adapter.service.impl;

import com.tbyf.his.adapter.domain.BCodevalue;
import com.tbyf.his.adapter.mapper.BCodevalueMapper;
import com.tbyf.his.adapter.service.IBCodevalueService;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Author:lph
 * Date:2022/11/18 13:57
 **/
@DataSource(value = DataSourceType.SLAVE)
@Service
public class BCodevalueServiceImpl implements IBCodevalueService {
    @Autowired
    private BCodevalueMapper bCodevalueMapper;

    /**
     * 查询业务代码值域 信息集合
     *
     * @param bCodevalue 业务代码值域 信息
     * @return 业务代码值域 信息集合
     */
    @Override
    public List<BCodevalue> selectBCodevalueList(BCodevalue bCodevalue) {
        return bCodevalueMapper.selectBCodevalueList(bCodevalue);
    }


    @Override
    public int updateBCodevalue(BCodevalue bCodevalue) {
        return bCodevalueMapper.updateBCodevalue(bCodevalue);
    }
}
