package com.tbyf.his.apiconvert.mapper;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 参数配置Mapper接口
 *
 * @author guopx
 * @date 2022-03-01
 */
public interface ApiconvertBaseinfoMapper {
    /**
     * 查询参数配置
     *
     * @param apiId 参数配置主键
     * @return 参数配置
     */
    public ApiconvertBaseinfo selectApiconvertBaseinfoByApiId(Long apiId);

    /**
     * 查询参数配置列表
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 参数配置集合
     */
    public List<ApiconvertBaseinfo> selectApiconvertBaseinfoList(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 新增参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    public int insertApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 修改参数配置
     *
     * @param apiconvertBaseinfo 参数配置
     * @return 结果
     */
    public int updateApiconvertBaseinfo(ApiconvertBaseinfo apiconvertBaseinfo);

    /**
     * 删除参数配置
     *
     * @param apiId 参数配置主键
     * @return 结果
     */
    public int deleteApiconvertBaseinfoByApiId(Long apiId);

    /**
     * 批量删除参数配置
     *
     * @param apiIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteApiconvertBaseinfoByApiIds(Long[] apiIds);

    public List<ApiconvertBaseinfo> selectApiconvertBaseinfoByApiIds(long[] apiIds);

    //targetProtocol==3 执行sql
    List<JSONObject> selectList(
            //@Param(value = "sqlStr") String sqlStr,
//            @Param(value = "param")
            Map<String, Object> param);

//    List<JSONObject> selectList(
//            @Param(value = "sqlStr") String sqlStr,
//            @Param(value = "param") Map<String, Object> param);

    //    JSONObject selectOne(@Param(value = "sqlStr") String sqlStr,
//                         @Param(value = "param") Map<String, Object> param);
    JSONObject selectOne(Map<String, Object> param);

    /**
     * 模糊查询获取下拉
     *
     * @param apiName
     * @return
     */
    List<MyKeyValue> selectByName(@Param("apiName") String apiName);

}
