package com.tbyf.his.configuration.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * DynamicQuery组件配置对象 dq_config
 *
 * @author guopx
 * @date 2022-05-18
 */
public class DqConfig extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private Long id;

    /**
     * 对象名称
     */
    @Excel(name = "对象名称")
    private String objName;

    /**
     * 控件用于查询
     */
    @Excel(name = "控件用于查询")
    private String isSearch;

    /**
     * 在类型最上面添加全部
     */
    @Excel(name = "在类型最上面添加全部")
    private String isAddAll;

    /**
     * 切换类型自动检索数据
     */
    @Excel(name = "切换类型自动检索数据")
    private String autoSearch;

    /**
     * 切换类型自动清空号码框
     */
    @Excel(name = "切换类型自动清空号码框")
    private String autoClear;

    /**
     * 挂号流水号自动添加前缀
     */
    @Excel(name = "挂号流水号自动添加前缀")
    private String autoAddPre;

    /**
     * 号码为空时回车检索数据
     */
    @Excel(name = "号码为空时回车检索数据")
    private String enterSearch;

    /**
     * 号码框回车跳转到下一个控件
     */
    @Excel(name = "号码框回车跳转到下一个控件")
    private String enterToNext;

    /**
     * 双击号码框复制内容到系统剪切板
     */
    @Excel(name = "双击号码框复制内容到系统剪切板")
    private String dbcCopy;

    /**
     * 双击号码框检索数据
     */
    @Excel(name = "双击号码框检索数据")
    private String dbcSearch;

    /**
     * 号码框上点右键清空内容
     */
    @Excel(name = "号码框上点右键清空内容")
    private String rightClickClear;

    /**
     * 号码框同时按Shift和回车清空内容并跳转到类型
     */
    @Excel(name = "号码框同时按Shift和回车清空内容并跳转到类型")
    private String autoClearToType;

    /**
     * 输入框显示大写
     */
    @Excel(name = "输入框显示大写")
    private String showUpper;

    /**
     * 其他参数
     */
    @Excel(name = "其他参数")
    private String otherParams;

    /**
     * 代码
     */
    @Excel(name = "代码")
    private String code;

    /**
     * $column.columnComment
     */
    @Excel(name = "代码")
    private String col3;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getObjName() {
        return objName;
    }

    public void setIsSearch(String isSearch) {
        this.isSearch = isSearch;
    }

    public String getIsSearch() {
        return isSearch;
    }

    public void setIsAddAll(String isAddAll) {
        this.isAddAll = isAddAll;
    }

    public String getIsAddAll() {
        return isAddAll;
    }

    public void setAutoSearch(String autoSearch) {
        this.autoSearch = autoSearch;
    }

    public String getAutoSearch() {
        return autoSearch;
    }

    public void setAutoClear(String autoClear) {
        this.autoClear = autoClear;
    }

    public String getAutoClear() {
        return autoClear;
    }

    public void setAutoAddPre(String autoAddPre) {
        this.autoAddPre = autoAddPre;
    }

    public String getAutoAddPre() {
        return autoAddPre;
    }

    public void setEnterSearch(String enterSearch) {
        this.enterSearch = enterSearch;
    }

    public String getEnterSearch() {
        return enterSearch;
    }

    public void setEnterToNext(String enterToNext) {
        this.enterToNext = enterToNext;
    }

    public String getEnterToNext() {
        return enterToNext;
    }

    public void setDbcCopy(String dbcCopy) {
        this.dbcCopy = dbcCopy;
    }

    public String getDbcCopy() {
        return dbcCopy;
    }

    public void setDbcSearch(String dbcSearch) {
        this.dbcSearch = dbcSearch;
    }

    public String getDbcSearch() {
        return dbcSearch;
    }

    public void setRightClickClear(String rightClickClear) {
        this.rightClickClear = rightClickClear;
    }

    public String getRightClickClear() {
        return rightClickClear;
    }

    public void setAutoClearToType(String autoClearToType) {
        this.autoClearToType = autoClearToType;
    }

    public String getAutoClearToType() {
        return autoClearToType;
    }

    public void setShowUpper(String showUpper) {
        this.showUpper = showUpper;
    }

    public String getShowUpper() {
        return showUpper;
    }

    public void setOtherParams(String otherParams) {
        this.otherParams = otherParams;
    }

    public String getOtherParams() {
        return otherParams;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public void setCol3(String col3) {
        this.col3 = col3;
    }

    public String getCol3() {
        return col3;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("objName", getObjName())
                .append("isSearch", getIsSearch())
                .append("isAddAll", getIsAddAll())
                .append("autoSearch", getAutoSearch())
                .append("autoClear", getAutoClear())
                .append("autoAddPre", getAutoAddPre())
                .append("enterSearch", getEnterSearch())
                .append("enterToNext", getEnterToNext())
                .append("dbcCopy", getDbcCopy())
                .append("dbcSearch", getDbcSearch())
                .append("rightClickClear", getRightClickClear())
                .append("autoClearToType", getAutoClearToType())
                .append("showUpper", getShowUpper())
                .append("remark", getRemark())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("otherParams", getOtherParams())
                .append("code", getCode())
                .append("col3", getCol3())
                .toString();
    }
}
