package com.tbyf.his.configuration.service.impl;

import java.util.List;

import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.configuration.mapper.DqConfigMapper;
import com.tbyf.his.configuration.service.IDqConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.tbyf.his.configuration.mapper.DqConfigMapper;
import com.tbyf.his.configuration.domain.DqConfig;
import com.tbyf.his.configuration.service.IDqConfigService;

/**
 * DynamicQuery组件配置Service业务层处理
 *
 * @author guopx
 * @date 2022-05-18
 */
@Service
public class DqConfigServiceImpl implements IDqConfigService {
    @Autowired
    private DqConfigMapper dqConfigMapper;

    /**
     * 查询DynamicQuery组件配置
     *
     * @param id DynamicQuery组件配置主键
     * @return DynamicQuery组件配置
     */
    @Override
    public DqConfig selectDqConfigById(Long id) {
        return dqConfigMapper.selectDqConfigById(id);
    }

    /**
     * 查询DynamicQuery组件配置列表
     *
     * @param dqConfig DynamicQuery组件配置
     * @return DynamicQuery组件配置
     */
    @Override
    public List<DqConfig> selectDqConfigList(DqConfig dqConfig) {
        return dqConfigMapper.selectDqConfigList(dqConfig);
    }

    /**
     * 新增DynamicQuery组件配置
     *
     * @param dqConfig DynamicQuery组件配置
     * @return 结果
     */
    @Override
    public int insertDqConfig(DqConfig dqConfig) {
        dqConfig.setCreateTime(DateUtils.getNowDate());
        return dqConfigMapper.insertDqConfig(dqConfig);
    }

    /**
     * 修改DynamicQuery组件配置
     *
     * @param dqConfig DynamicQuery组件配置
     * @return 结果
     */
    @Override
    public int updateDqConfig(DqConfig dqConfig) {
        dqConfig.setUpdateTime(DateUtils.getNowDate());
        return dqConfigMapper.updateDqConfig(dqConfig);
    }

    /**
     * 批量删除DynamicQuery组件配置
     *
     * @param ids 需要删除的DynamicQuery组件配置主键
     * @return 结果
     */
    @Override
    public int deleteDqConfigByIds(Long[] ids) {
        return dqConfigMapper.deleteDqConfigByIds(ids);
    }

    /**
     * 删除DynamicQuery组件配置信息
     *
     * @param id DynamicQuery组件配置主键
     * @return 结果
     */
    @Override
    public int deleteDqConfigById(Long id) {
        return dqConfigMapper.deleteDqConfigById(id);
    }
}
