package com.tbyf.his.configuration.service.impl;

import java.util.List;

import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.configuration.domain.WsConfig;
import com.tbyf.his.configuration.domain.WsConfigDetail;
import com.tbyf.his.configuration.mapper.WsConfigDetailMapper;
import com.tbyf.his.configuration.mapper.WsConfigMapper;
import com.tbyf.his.configuration.service.IWsConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * webService服务配置Service业务层处理
 *
 * @author guopx
 * @date 2022-04-14
 */
@Service
public class WsConfigServiceImpl implements IWsConfigService {
    @Autowired
    private WsConfigMapper wsConfigMapper;
    @Autowired
    private WsConfigDetailMapper wsConfigDetailMapper;

    /**
     * 查询webService服务配置
     *
     * @param id webService服务配置主键
     * @return webService服务配置
     */
    @Override
    public WsConfig selectWsConfigById(Long id) {
        return wsConfigMapper.selectWsConfigById(id);
    }

    /**
     * 查询webService服务配置列表
     *
     * @param wsConfig webService服务配置
     * @return webService服务配置
     */
    @Override
    public List<WsConfig> selectWsConfigList(WsConfig wsConfig) {
        return wsConfigMapper.selectWsConfigList(wsConfig);
    }

    /**
     * 新增webService服务配置
     *
     * @param wsConfig webService服务配置
     * @return 结果
     */
    @Override
    public int insertWsConfig(WsConfig wsConfig) {
        wsConfig.setCreateTime(DateUtils.getNowDate());
        int i1 = wsConfigMapper.insertWsConfig(wsConfig);

        Long id = wsConfig.getId();
        //arg10固定赋值
        for (int i = 1; i <= 9; i++) {
            WsConfigDetail detail = new WsConfigDetail();
            detail.setOrderNum(i);
            detail.setWsConfigId(id);
            detail.setXmlFlag("0");
            detail.setParamKey("arg" + i);
            detail.setTargetKey("arg" + i);
            detail.setParamType("string");
            detail.setCreateTime(DateUtils.getNowDate());
            wsConfigDetailMapper.insertWsConfigDetail(detail);
        }

        return i1;
    }

    /**
     * 修改webService服务配置
     *
     * @param wsConfig webService服务配置
     * @return 结果
     */
    @Override
    public int updateWsConfig(WsConfig wsConfig) {
        wsConfig.setUpdateTime(DateUtils.getNowDate());
        return wsConfigMapper.updateWsConfig(wsConfig);
    }

    /**
     * 批量删除webService服务配置
     *
     * @param ids 需要删除的webService服务配置主键
     * @return 结果
     */
    @Override
    public int deleteWsConfigByIds(Long[] ids) {
        return wsConfigMapper.deleteWsConfigByIds(ids);
    }

    /**
     * 删除webService服务配置信息
     *
     * @param id webService服务配置主键
     * @return 结果
     */
    @Override
    public int deleteWsConfigById(Long id) {
        return wsConfigMapper.deleteWsConfigById(id);
    }

    @Override
    public List<WsConfig> selectWsConfigByModuleId(Long moduleId) {
        return wsConfigMapper.selectWsConfigByModuleId(moduleId);
    }
}
