package com.tbyf.his.job.obj;

import com.tbyf.his.job.domain.SysJobNew;
import com.tbyf.his.job.util.JobInvokeUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

/**
 * @author: fr
 * @date: 2022年07月25日 14:53
 */
@Service
public class JobExecuteMethod implements JobExecute, InitializingBean, DisposableBean {
    @Override
    public void execute(SysJobNew job) throws Exception {
        JobInvokeUtil.invokeMethod(job);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册进入工厂
        JobExecuteFactory.register(JobEnum.EXECUTE_METHOD, this);
    }

    @Override
    public void destroy() throws Exception {
        JobExecuteFactory.remove(JobEnum.EXECUTE_METHOD, this);
    }
}
