package com.tbyf.his.job.util;

import com.tbyf.his.job.domain.SysJobNew;
import com.tbyf.his.job.obj.JobEnum;
import com.tbyf.his.job.obj.JobExecuteFactory;
import org.quartz.JobExecutionContext;

/**
 * 定时任务处理（允许并发执行）
 *
 * @author guopx
 */
public class QuartzJobExecution extends AbstractQuartzJob {
    @Override
    protected void doExecute(JobExecutionContext context, SysJobNew sysJob) throws Exception {
        JobEnum jobEnum = JobEnum.getByType(Integer.parseInt(sysJob.getType()));
        JobExecuteFactory.getJobExecute(jobEnum).execute(sysJob);
    }
}
