package com.tbyf.his.login.service;


import com.tbyf.his.common.constant.Constants;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

/**
 * 登录校验方法
 *
 * @author guopx
 */
@Component
@Slf4j
public class CaptchaService {

    //缓存验证码
    @Cacheable(value = Constants.CAPTCHA_CODE_KEY, key = "#p0")
    public String cacheCaptcha(String uuid, String code) {
        return code;
    }

    /**
     * 清理验证码
     *
     * @param uuid 唯一标识
     * @return 结果
     */
    @CacheEvict(value = Constants.CAPTCHA_CODE_KEY, key = "#uuid")
    public void removeCaptcha(String uuid) {

    }
}
