package com.tbyf.his.platform.service.impl;


import com.tbyf.his.adapter.domain.BCodevalue;
import com.tbyf.his.analysis.domain.BDatasetvsmetadata;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.platform.domain.BDatasetvsmetadataVo;
import com.tbyf.his.platform.mapper.BDatasetvsmetadataMapper;
import com.tbyf.his.platform.service.IBDatasetvsmetadataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 数据集关联数据元 服务层实现
 *
 * @author guopx
 * @date 2020/10/21
 */
@DataSource(value = DataSourceType.SLAVE)
@Service
public class BDatasetvsmetadataServiceImpl implements IBDatasetvsmetadataService {
    @Autowired
    private BDatasetvsmetadataMapper bDatasetvsmetadataMapper;

    /**
     * 查询数据集关联数据元 信息集合
     *
     * @param bDatasetvsmetadata 数据集关联数据元 信息
     * @return 数据集关联数据元 信息集合
     */
    @Override
    public List<BDatasetvsmetadataVo> selectBDatasetvsmetadataList(BDatasetvsmetadata bDatasetvsmetadata) {
        List<BDatasetvsmetadataVo> list = bDatasetvsmetadataMapper.selectBDatasetvsmetadataList(bDatasetvsmetadata);
        list.stream().forEach(x -> {
            if (x.getmETADATALENGTH() != null) {
                x.setmETADATATYPE(x.getmETADATATYPE() + "(" + x.getmETADATALENGTH() + ")");
            }
        });

        return list;
    }

}

