package com.tbyf.his.print.mapper;


import com.tbyf.his.print.domain.PrintDataset;

import java.util.List;

/**
 * 数据集信息Mapper接口
 *
 * @author x
 * @date 2022-02-25
 */
public interface PrintDatasetMapper {
    /**
     * 查询数据集信息
     *
     * @param datasetId 数据集信息主键
     * @return 数据集信息
     */
    public PrintDataset selectPrintDatasetByDatasetId(Long datasetId);

    /**
     * 查询数据集信息列表
     *
     * @param printDataset 数据集信息
     * @return 数据集信息集合
     */
    public List<PrintDataset> selectPrintDatasetList(PrintDataset printDataset);

    /**
     * 新增数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    public int insertPrintDataset(PrintDataset printDataset);

    /**
     * 修改数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    public int updatePrintDataset(PrintDataset printDataset);

    /**
     * 删除数据集信息
     *
     * @param datasetId 数据集信息主键
     * @return 结果
     */
    public int deletePrintDatasetByDatasetId(Long datasetId);

    /**
     * 批量删除数据集信息
     *
     * @param datasetIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePrintDatasetByDatasetIds(Long[] datasetIds);

    /**
     * 批量删除数据元信息
     *
     * @param datasetIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deletePrintMetadataByDatasetIds(Long[] datasetIds);

    /**
     * 通过数据集信息主键删除数据元信息信息
     *
     * @param datasetId 数据集信息ID
     * @return 结果
     */
    public int deletePrintMetadataByDatasetId(Long datasetId);

    /**
     * 数据集集合包括数据元
     *
     * @param
     * @return 结果
     */
    public List<PrintDataset> selectPrintDatasetAndMetadataList();
}
