package com.tbyf.his.print.service;


import com.tbyf.his.print.domain.PrintDataset;

import java.util.List;

/**
 * 数据集信息Service接口
 *
 * @author x
 * @date 2022-02-25
 */
public interface IPrintDatasetService {
    /**
     * 查询数据集信息
     *
     * @param datasetId 数据集信息主键
     * @return 数据集信息
     */
    public PrintDataset selectPrintDatasetByDatasetId(Long datasetId);

    /**
     * 查询数据集信息列表
     *
     * @param printDataset 数据集信息
     * @return 数据集信息集合
     */
    public List<PrintDataset> selectPrintDatasetList(PrintDataset printDataset);

    /**
     * 新增数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    public int insertPrintDataset(PrintDataset printDataset);

    /**
     * 修改数据集信息
     *
     * @param printDataset 数据集信息
     * @return 结果
     */
    public int updatePrintDataset(PrintDataset printDataset);

    /**
     * 批量删除数据集信息
     *
     * @param datasetIds 需要删除的数据集信息主键集合
     * @return 结果
     */
    public int deletePrintDatasetByDatasetIds(Long[] datasetIds);

    /**
     * 删除数据集信息信息
     *
     * @param datasetId 数据集信息主键
     * @return 结果
     */
    public int deletePrintDatasetByDatasetId(Long datasetId);

    List<PrintDataset> allFieldList();
}
